/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.model;

import com.sun.javaee.blueprints.components.ui.model.Graph;
import java.util.ArrayList;
import java.util.Iterator;

public class Node {
    private ArrayList children = new ArrayList();
    protected Graph graph = null;
    private String action = null;
    private String icon = null;
    private int depth = 1;
    private boolean enabled = false;
    private boolean expanded = false;
    private String label = null;
    private String name = null;
    private Node parent = null;
    private boolean selected = false;
    protected boolean last = false;

    public Node() {
    }

    public Node(String name, String label, String action, String icon, boolean enabled, boolean expanded) {
        this.setName(name);
        this.setLabel(label);
        this.setAction(action);
        this.setIcon(icon);
        this.setEnabled(enabled);
        this.setExpanded(expanded);
    }

    void setGraph(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Node getParent() {
        return this.parent;
    }

    void setParent(Node parent) {
        this.parent = parent;
        this.depth = parent == null ? 1 : parent.getDepth() + 1;
    }

    public String getPath() {
        Node parent = this.getParent();
        if (parent == null) {
            return "/";
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getName());
        while (parent != null) {
            list.add(0, parent.getPath());
            parent = parent.getParent();
        }
        StringBuffer sb = new StringBuffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i != 1) {
                sb.append("/");
            }
            if (i <= 0) continue;
            sb.append((String)list.get(i));
        }
        return sb.toString();
    }

    public boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isLast() {
        return this.last;
    }

    void setLast(boolean last) {
        this.last = last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeaf() {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            return this.children.size() < 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Node child) {
        if (child.getParent() != null) {
            throw new IllegalArgumentException("Child already has a parent");
        }
        if (this.graph != null) {
            this.graph.addNode(child);
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.add(child);
        }
        child.setParent(this);
        int n = this.children.size();
        if (n > 0) {
            Node node = (Node)this.children.get(n - 1);
            node.setLast(false);
        }
        child.setLast(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(int offset, Node child) {
        if (child.getParent() != null) {
            throw new IllegalArgumentException("Child already has a parent");
        }
        if (this.graph != null) {
            this.graph.addNode(child);
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.add(offset, child);
        }
        child.setParent(this);
    }

    public Node findChild(String name) {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Node kid = (Node)this.children.get(i);
            if (!name.equals(kid.getName())) continue;
            return kid;
        }
        return null;
    }

    public Iterator getChildren() {
        return this.children.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(Node child) {
        if (child.getParent() != this) {
            throw new IllegalArgumentException("Child not related to this node");
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.remove(child);
        }
        this.graph.removeNode(child);
        child.setParent(null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Node[name=");
        sb.append(this.name);
        if (this.label != null) {
            sb.append(",label=");
            sb.append(this.label);
        }
        if (this.action != null) {
            sb.append(",action=");
            sb.append(this.action);
        }
        sb.append(",enabled=");
        sb.append(this.enabled);
        sb.append(",expanded=");
        sb.append(this.expanded);
        sb.append("]");
        return sb.toString();
    }
}

