/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.popup;

import com.sun.javaee.blueprints.components.ui.popup.PopupUtil;
import java.io.OutputStream;
import java.net.URL;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletResponse;

public class PopupPhaseListener
implements PhaseListener {
    public static final String PATH_PREFIX = "/META-INF/popup";
    public static final String SCRIPT_SUFFIX = ".js";
    public static final String CSS_SUFFIX = ".css";
    public static final String GIF_SUFFIX = ".gif";
    public static final String JPG_SUFFIX = ".jpg";
    public static final String PNG_SUFFIX = ".png";
    public static boolean bDebug = false;

    public void afterPhase(PhaseEvent event) {
        String rootId = event.getFacesContext().getViewRoot().getViewId();
        if (bDebug) {
            System.out.println("PhaseListener - Root ID " + rootId);
        }
        if (rootId.endsWith(SCRIPT_SUFFIX)) {
            this.handleResourceRequest(event, PATH_PREFIX + rootId, "text/javascript");
        } else if (rootId.endsWith(CSS_SUFFIX)) {
            this.handleResourceRequest(event, PATH_PREFIX + rootId, "text/css");
        } else if (rootId.endsWith(GIF_SUFFIX)) {
            this.handleResourceRequest(event, PATH_PREFIX + rootId, "image/gif");
        } else if (rootId.endsWith(JPG_SUFFIX)) {
            this.handleResourceRequest(event, PATH_PREFIX + rootId, "image/jpeg");
        } else if (rootId.endsWith(PNG_SUFFIX)) {
            this.handleResourceRequest(event, PATH_PREFIX + rootId, "image/x-png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResourceRequest(PhaseEvent event, String resource, String contentType) {
        URL sxURL = PopupPhaseListener.class.getResource(resource);
        HttpServletResponse response = (HttpServletResponse)event.getFacesContext().getExternalContext().getResponse();
        OutputStream outStream = null;
        try {
            response.setContentType(contentType);
            response.setStatus(200);
            outStream = response.getOutputStream();
            PopupUtil.readWriteBinaryUtil(sxURL, outStream);
        }
        catch (Exception e) {
            String message = "Can't find resource \"" + resource + "\" in the same directory as the class - " + this.getClass().getResource("PopupPhaseListener.class");
            System.out.println(message);
            e.printStackTrace();
        }
        finally {
            try {
                outStream.flush();
                outStream.close();
            }
            catch (Exception ee) {}
            event.getFacesContext().responseComplete();
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
}

