/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.slider_navigator;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletResponse;

public class SlideshowPhaseListener
implements PhaseListener {
    public static final String PATH_PREFIX = "/META-INF/slider-navigator/";
    public static final String SCRIPT_VIEW_ID = "ajax-slideshow-script.js";
    public static final String AJAX_SCRIPT_VIEW_ID = "ajax-common-script.js";
    public static final String XSL_SCRIPT_VIEW_ID = "xsl-script.js";
    public static final String CAT_XSL_VIEW_ID = "cats.xsl";
    public static final String CSS_VIEW_ID = "ajax-slideshow.css";
    public static final String GIF_SUFFIX = ".gif";
    public static final String JPG_SUFFIX = ".jpg";
    public static final String PNG_SUFFIX = ".png";

    public void afterPhase(PhaseEvent event) {
        String rootId = event.getFacesContext().getViewRoot().getViewId();
        String realPath = null;
        if (rootId.endsWith(SCRIPT_VIEW_ID)) {
            System.out.println("IN AFTERPHASE - SLIDESHOW.JS");
            this.handleResourceRequest(event, "/META-INF/slider-navigator/slideshow.js", "text/javascript");
        } else if (rootId.endsWith(XSL_SCRIPT_VIEW_ID)) {
            this.handleResourceRequest(event, "/META-INF/slider-navigator/xslt.js", "text/javascript");
        } else if (rootId.endsWith(AJAX_SCRIPT_VIEW_ID)) {
            this.handleResourceRequest(event, "/META-INF/slider-navigator/xmlhttprequest.js", "text/javascript");
        } else if (rootId.endsWith(CAT_XSL_VIEW_ID)) {
            this.handleResourceRequest(event, "/META-INF/slider-navigator/cats.xsl", "application/xml;charset=UTF-8");
        } else if (rootId.endsWith(CSS_VIEW_ID)) {
            this.handleResourceRequest(event, "styles.css", "text/css");
        } else if (rootId.endsWith(GIF_SUFFIX)) {
            this.handleResourceRequest(event, realPath, "image/gif");
        } else if (rootId.endsWith(JPG_SUFFIX)) {
            this.handleResourceRequest(event, realPath, "image/jpeg");
        } else if (rootId.endsWith(PNG_SUFFIX)) {
            this.handleResourceRequest(event, realPath, "image/x-png");
        }
    }

    private void handleResourceRequest(PhaseEvent event, String resource, String contentType) {
        URL url = SlideshowPhaseListener.class.getResource(resource);
        URLConnection conn = null;
        InputStream stream = null;
        BufferedReader bufReader = null;
        HttpServletResponse response = (HttpServletResponse)event.getFacesContext().getExternalContext().getResponse();
        OutputStreamWriter outWriter = null;
        String curLine = null;
        try {
            outWriter = new OutputStreamWriter((OutputStream)response.getOutputStream(), response.getCharacterEncoding());
            conn = url.openConnection();
            conn.setUseCaches(false);
            stream = conn.getInputStream();
            bufReader = new BufferedReader(new InputStreamReader(stream));
            response.setContentType(contentType);
            response.setStatus(200);
            while (null != (curLine = bufReader.readLine())) {
                outWriter.write(curLine + "\n");
            }
            outWriter.flush();
            outWriter.close();
            event.getFacesContext().responseComplete();
        }
        catch (Exception e) {
            String message = "Can't load resource:" + url.toExternalForm();
            System.err.println(message);
            e.printStackTrace();
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
}

