/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.taglib;

import com.sun.javaee.blueprints.components.ui.components.ProgressBarComponent;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentELTag;

public class ProgressBarTag
extends UIComponentELTag {
    protected ValueExpression value;
    private ValueExpression interval;
    private MethodExpression action;

    public void setValue(ValueExpression newValue) {
        this.value = newValue;
    }

    public void setInterval(ValueExpression newInterval) {
        this.interval = newInterval;
    }

    public String getComponentType() {
        return "ProgressBar";
    }

    public String getRendererType() {
        return "ProgressBar";
    }

    public void release() {
        super.release();
        this.value = null;
        this.interval = null;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        ProgressBarComponent progressBar = (ProgressBarComponent)component;
        if (this.interval != null) {
            if (!this.interval.isLiteralText()) {
                progressBar.setValueExpression("interval", this.interval);
            } else {
                Integer timeInterval = new Integer(this.interval.getExpressionString());
                try {
                    int millis = timeInterval;
                    progressBar.setInterval(millis);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (this.value != null) {
            if (!this.value.isLiteralText()) {
                progressBar.setValueExpression("value", this.value);
            } else {
                progressBar.setValue(this.value.getExpressionString());
            }
        }
        if (this.action != null) {
            progressBar.setActionExpression(this.action);
        }
    }

    public MethodExpression getAction() {
        return this.action;
    }

    public void setAction(MethodExpression action) {
        this.action = action;
    }
}

