/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tlddoc;

import com.sun.tlddoc.GeneratorException;
import com.sun.tlddoc.TagLibrary;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TagDirImplicitTagLibrary
extends TagLibrary {
    private File dir;

    public TagDirImplicitTagLibrary(File dir) {
        this.dir = dir;
    }

    public String getPathDescription() {
        return this.dir.getAbsolutePath();
    }

    public InputStream getResource(String path) throws IOException {
        FileInputStream result = null;
        File dir = this.dir;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        File look = null;
        while (dir != null && !(look = new File(dir, path)).exists()) {
            dir = dir.getParentFile();
        }
        if (look != null && look.exists()) {
            result = new FileInputStream(look);
        }
        return result;
    }

    public Document getTLDDocument(DocumentBuilder documentBuilder) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException, GeneratorException {
        Document result = documentBuilder.newDocument();
        String path = this.dir.getAbsolutePath().replace(File.separatorChar, '/');
        int index = path.indexOf("/WEB-INF/");
        path = index != -1 ? path.substring(index) : "unknown";
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        Element taglibElement = TagDirImplicitTagLibrary.createRootTaglibNode(result, path);
        File[] files = this.dir.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].isDirectory() || !files[i].getName().toLowerCase().endsWith(".tag") && !files[i].getName().toLowerCase().endsWith(".tagx")) continue;
            String tagName = files[i].getName().substring(0, files[i].getName().lastIndexOf(46));
            String tagPath = path + files[i].getName();
            Element tagFileElement = result.createElement("tag-file");
            Element nameElement = result.createElement("name");
            nameElement.appendChild(result.createTextNode(tagName));
            tagFileElement.appendChild(nameElement);
            Element pathElement = result.createElement("path");
            pathElement.appendChild(result.createTextNode(tagPath));
            tagFileElement.appendChild(pathElement);
            taglibElement.appendChild(tagFileElement);
            files[i].getName();
        }
        StringWriter buffer = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(result), new StreamResult(buffer));
        result = documentBuilder.parse(new InputSource(new StringReader(buffer.toString())));
        return result;
    }

    protected static Element createRootTaglibNode(Document result, String path) {
        String shortName;
        Element taglibElement = result.createElementNS("http://java.sun.com/xml/ns/javaee", "taglib");
        taglibElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://java.sun.com/xml/ns/javaee");
        taglibElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        taglibElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-jsptaglibrary_2_1.xsd");
        taglibElement.setAttribute("version", "2.1");
        result.appendChild(taglibElement);
        Element descriptionElement = result.createElement("description");
        descriptionElement.appendChild(result.createTextNode("Implicit tag library for tag file directory " + path));
        taglibElement.appendChild(descriptionElement);
        Element tlibVersionElement = result.createElement("tlib-version");
        tlibVersionElement.appendChild(result.createTextNode("1.0"));
        taglibElement.appendChild(tlibVersionElement);
        if (path.equals("unknown")) {
            shortName = path;
        } else if (path.equals("/WEB-INF/tags") || path.equals("/WEB-INF/tags/")) {
            shortName = "tags";
        } else {
            shortName = path;
            if (shortName.startsWith("/WEB-INF/tags")) {
                shortName = shortName.substring("/WEB-INF/tags".length());
            }
            if (shortName.startsWith("/")) {
                shortName = shortName.substring(1);
            }
            if (shortName.endsWith("/")) {
                shortName = shortName.substring(0, shortName.length() - 1);
            }
            shortName = shortName.replace(File.separatorChar, '/');
            shortName = shortName.replace('/', '-');
        }
        Element shortNameElement = result.createElement("short-name");
        shortNameElement.appendChild(result.createTextNode(shortName));
        taglibElement.appendChild(shortNameElement);
        Element uriElement = result.createElement("uri");
        uriElement.appendChild(result.createTextNode(path));
        taglibElement.appendChild(uriElement);
        return taglibElement;
    }
}

