/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.cactus;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.cactus.CompareFiles;
import com.sun.faces.cactus.FacesTestCase;
import com.sun.faces.cactus.FileOutputResponseWrapper;
import com.sun.faces.cactus.FileOutputResponseWriter;
import com.sun.faces.cactus.TestBean;
import com.sun.faces.cactus.TestingUtil;
import com.sun.faces.config.ConfigureListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import junit.framework.Assert;
import org.apache.cactus.server.ServletContextWrapper;

public class FacesTestCaseService {
    public static final String ENTER_CALLED = "enterCalled";
    public static final String EXIT_CALLED = "exitCalled";
    public static final String EMPTY = "empty";
    protected FacesTestCase facesTestCase = null;
    protected Assert assertVendor = null;
    protected FacesContextFactory facesContextFactory = null;
    protected FacesContext facesContext = null;
    protected ConfigureListener configureListener = null;
    protected Lifecycle lifecycle = null;
    protected ServletContext servletContext = null;

    public FacesTestCaseService(FacesTestCase newFacesTestCase) {
        this.facesTestCase = newFacesTestCase;
        this.assertVendor = (Assert)this.facesTestCase;
    }

    public FacesContext getFacesContext() {
        return this.facesContext;
    }

    public FacesContextFactory getFacesContextFactory() {
        return this.facesContextFactory;
    }

    public void setUp() {
        FacesContext oldContext = FacesContext.getCurrentInstance();
        if (null != oldContext) {
            oldContext.release();
        }
        this.servletContext = this.facesTestCase.getConfig().getServletContext();
        Object response = null;
        TestingUtil.setUnitTestModeEnabled(true);
        String testRootDir = this.servletContext.getInitParameter("testRootDir");
        assert (null != testRootDir);
        this.facesTestCase.setTestRootDir(testRootDir);
        this.configureListener = new ConfigureListener();
        ServletContextEvent e = new ServletContextEvent(this.servletContext);
        if (null == this.servletContext.getAttribute("javax.faces.CONFIG_FILES")) {
            System.out.println("INVOKING CONFIGLISTENER");
            this.configureListener.contextDestroyed(e);
            FactoryFinder.releaseFactories();
            this.configureListener.contextInitialized(e);
            FacesContext.getCurrentInstance().release();
        }
        this.initFacesContext();
        if (this.facesTestCase.sendWriterToFile()) {
            FileOutputResponseWriter responseWriter = new FileOutputResponseWriter(testRootDir);
            this.facesContext.setResponseWriter((ResponseWriter)responseWriter);
        }
        TestBean testBean = new TestBean();
        this.facesContext.getExternalContext().getSessionMap().put("TestBean", testBean);
        UIViewRoot root = this.getFacesContext().getApplication().getViewHandler().createView(this.facesContext, null);
        root.setViewId("/viewId");
        this.facesContext.setViewRoot(root);
        this.facesContext.setCurrentPhaseId(PhaseId.RESTORE_VIEW);
    }

    public void tearDown() {
        if (this.servletContext != null) {
            this.servletContext.removeAttribute("com.sun.faces.HTML_BASIC");
        }
        ServletContextEvent e = new ServletContextEvent(this.servletContext);
        this.configureListener.contextDestroyed(e);
        try {
            if (this.facesContext.getExternalContext() != null && this.facesContext.getExternalContext().getSession(true) != null) {
                this.facesContext.getExternalContext().getSessionMap().remove("TestBean");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.servletContext = null;
    }

    public boolean verifyExpectedOutput() {
        boolean result = false;
        CompareFiles cf = new CompareFiles();
        String errorMessage = null;
        String outputFileName = null;
        String correctFileName = null;
        if (!this.facesTestCase.sendResponseToFile() && !this.facesTestCase.sendWriterToFile() && null == this.facesTestCase.getExpectedOutputFilename()) {
            return true;
        }
        outputFileName = this.facesTestCase.sendResponseToFile() ? FileOutputResponseWrapper.FACES_RESPONSE_FILENAME : FileOutputResponseWriter.RESPONSE_WRITER_FILENAME;
        correctFileName = FileOutputResponseWriter.FACES_RESPONSE_ROOT + this.facesTestCase.getExpectedOutputFilename();
        errorMessage = "File Comparison failed: diff -u " + outputFileName + " " + correctFileName;
        ArrayList<String> ignoreList = null;
        String[] ignore = null;
        ignore = this.facesTestCase.getLinesToIgnore();
        if (null != ignore) {
            ignoreList = new ArrayList<String>();
            for (int i = 0; i < ignore.length; ++i) {
                ignoreList.add(ignore[i]);
            }
        }
        try {
            result = CompareFiles.filesIdentical(outputFileName, correctFileName, ignoreList);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        if (!result) {
            System.out.println(errorMessage);
        }
        System.out.println("VERIFY:" + result);
        return result;
    }

    public void verifyEqualsContractPositive(Object x, Object y, Object z) {
        Assert.assertTrue((boolean)x.equals(x));
        Assert.assertTrue((x.equals(y) && y.equals(x) ? 1 : 0) != 0);
        Assert.assertTrue((x.equals(y) && y.equals(z) && x.equals(z) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.equals(y));
        Assert.assertTrue((boolean)x.equals(y));
        Assert.assertTrue((boolean)x.equals(y));
        Assert.assertTrue((boolean)y.equals(z));
        Assert.assertTrue((boolean)y.equals(z));
        Assert.assertTrue((boolean)y.equals(z));
        Assert.assertFalse((boolean)x.equals(null));
        Assert.assertFalse((boolean)y.equals(null));
        Assert.assertFalse((boolean)z.equals(null));
    }

    public boolean verifyExpectedStringInOutput(String str) {
        boolean exists = false;
        String outputFileName = null;
        if (!this.facesTestCase.sendResponseToFile() && !this.facesTestCase.sendWriterToFile() && null == this.facesTestCase.getExpectedOutputFilename()) {
            return true;
        }
        outputFileName = this.facesTestCase.sendResponseToFile() ? FileOutputResponseWrapper.FACES_RESPONSE_FILENAME : FileOutputResponseWriter.RESPONSE_WRITER_FILENAME;
        try {
            File fileToCheck = new File(outputFileName);
            FileReader fileReader = new FileReader(fileToCheck);
            LineNumberReader lineReader = new LineNumberReader(fileReader);
            String line = lineReader.readLine().trim();
            while (null != line) {
                if (line.indexOf(str) >= 0) {
                    exists = true;
                    break;
                }
                line = lineReader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return exists;
    }

    public boolean isMember(String toTest, String[] set) {
        int len = set.length;
        int i = 0;
        for (i = 0; i < len; ++i) {
            if (!set[i].equals(toTest)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubset(String[] subset, Iterator superset) {
        int i;
        int len = subset.length;
        boolean[] hits = new boolean[len];
        String cur = null;
        for (i = 0; i < len; ++i) {
            hits[i] = false;
        }
        while (superset.hasNext()) {
            cur = (String)superset.next();
            for (i = 0; i < len; ++i) {
                if (!cur.equals(subset[i])) continue;
                hits[i] = true;
            }
        }
        for (i = 0; i < len; ++i) {
            if (hits[i]) continue;
            return false;
        }
        return true;
    }

    public boolean requestsHaveSameAttributeSet(HttpServletRequest request1, HttpServletRequest request2) {
        Object valB;
        Object valA;
        String curAttr;
        Enumeration attrNames = request1.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            curAttr = (String)attrNames.nextElement();
            valA = request1.getAttribute(curAttr);
            valB = request2.getAttribute(curAttr);
            if (!(null != valA && null != valB ? !valA.equals(valB) : null != valA || null != valB)) continue;
            return false;
        }
        attrNames = request2.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            curAttr = (String)attrNames.nextElement();
            valA = request2.getAttribute(curAttr);
            valB = request1.getAttribute(curAttr);
            if (!(null != valA && null != valB ? !valA.equals(valB) : null != valA || null != valB)) continue;
            return false;
        }
        return true;
    }

    public void loadFromInitParam(String paramValue) {
        final String paramVal = paramValue;
        this.servletContext.removeAttribute("javax.faces.CONFIG_FILES");
        ApplicationAssociate.clearInstance((ExternalContext)FacesContext.getCurrentInstance().getExternalContext());
        FactoryFinder.releaseFactories();
        ServletContextWrapper sc = new ServletContextWrapper(this.servletContext){

            public String getInitParameter(String theName) {
                if (null != theName && theName.equals("javax.faces.CONFIG_FILES")) {
                    return paramVal;
                }
                return super.getInitParameter(theName);
            }

            public String getContextPath() {
                return "/test";
            }
        };
        ServletContextEvent e = new ServletContextEvent((ServletContext)sc);
        ApplicationAssociate.setCurrentInstance(null);
        this.configureListener.contextDestroyed(new ServletContextEvent(this.servletContext));
        this.servletContext = sc;
        this.configureListener = new ConfigureListener();
        this.configureListener.contextInitialized(e);
        this.initFacesContext();
    }

    public Object wrapRequestToHideParameters() {
        Object oldRequest = this.getFacesContext().getExternalContext().getRequest();
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper((HttpServletRequest)oldRequest){

            public Enumeration getParameterNames() {
                return new Enumeration(){

                    @Override
                    public boolean hasMoreElements() {
                        return false;
                    }

                    public Object nextElement() {
                        return new NoSuchElementException();
                    }
                };
            }
        };
        this.getFacesContext().getExternalContext().setRequest((Object)wrapper);
        return oldRequest;
    }

    public void unwrapRequestToShowParameters(Object oldRequest) {
        this.getFacesContext().getExternalContext().setRequest(oldRequest);
    }

    public void setModificationTime(String relativePath, long modTime) {
        String basePath = System.getProperty("explodedWarDir");
        if (null == basePath || 0 == basePath.length()) {
            throw new IllegalArgumentException("SystemProperty ''explodedWarDir'' not set or set to empty value.  Please set this value to be the fully qualified local file path to the exploded test war.");
        }
        File toMod = new File(basePath, relativePath);
        toMod.setLastModified(modTime);
    }

    private void initFacesContext() {
        Object response = this.facesTestCase.sendResponseToFile() ? new FileOutputResponseWrapper(this.facesTestCase.getResponse(), this.facesTestCase.getTestRootDir()) : this.facesTestCase.getResponse();
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        assert (null != factory);
        this.lifecycle = factory.getLifecycle("DEFAULT");
        assert (null != this.lifecycle);
        this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        this.facesContext = this.facesContextFactory.getFacesContext((Object)this.servletContext, (Object)this.facesTestCase.getRequest(), response, this.lifecycle);
    }
}

