/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.htmlunit;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.sun.faces.htmlunit.HtmlUnitFacesTestCase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SimpleTesterTestCase
extends HtmlUnitFacesTestCase {
    private String regexp = null;
    private boolean isTextPage;

    public SimpleTesterTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(SimpleTesterTestCase.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        String regexpFilename = System.getProperty("regexpFile");
        if (null != regexpFilename && 0 < regexpFilename.length()) {
            File regexpFile = new File(regexpFilename);
            this.regexp = this.readLineFromFile(regexpFile);
        } else {
            this.regexp = System.getProperty("regexp");
        }
        String textPageValue = System.getProperty("textPage");
        if (null != textPageValue && 0 < textPageValue.length()) {
            this.isTextPage = "true".equalsIgnoreCase(textPageValue);
        }
    }

    protected TextPage getTextPage(String path) throws Exception {
        TextPage result = (TextPage)this.client.getPage(this.getURL(path));
        return result;
    }

    private String readLineFromFile(File file) throws Exception {
        String result = null;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        result = reader.readLine();
        reader.close();
        return result;
    }

    private void doRegexp(String text) throws Exception {
        if (null != System.getProperty("SimpleTesterTestCase.dumpText") && "true".equalsIgnoreCase(System.getProperty("SimpleTesterTestCase.dumpText"))) {
            System.out.flush();
            System.out.println(text);
            System.out.flush();
        }
        if (null != this.regexp && 0 < this.regexp.length()) {
            SimpleTesterTestCase.assertTrue((boolean)text.matches(this.regexp));
        }
    }

    public void testMethod() throws Exception {
        this.client.setThrowExceptionOnFailingStatusCode(false);
        String request = System.getProperty("request");
        SimpleTesterTestCase.assertNotNull((Object)request);
        SimpleTesterTestCase.assertTrue((String)"invalid request attribute", (0 < request.length() ? 1 : 0) != 0);
        String status = System.getProperty("status");
        HtmlPage page = null;
        if (!this.isTextPage) {
            page = this.getPage(request);
            this.doRegexp(page.asXml());
        } else {
            page = this.getTextPage(request);
            this.doRegexp(((TextPage)page).getContent());
        }
        if (null != status && 0 < status.length()) {
            int expected = Integer.parseInt(status);
            int actual = page.getWebResponse().getStatusCode();
            SimpleTesterTestCase.assertEquals((int)expected, (int)actual);
        }
    }
}

