/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mock;

import com.sun.el.ExpressionFactoryImpl;
import com.sun.faces.mock.MockMethodBinding;
import com.sun.faces.mock.MockPropertyResolver;
import com.sun.faces.mock.MockResourceHandler;
import com.sun.faces.mock.MockServletContext;
import com.sun.faces.mock.MockStateManager;
import com.sun.faces.mock.MockValueBinding;
import com.sun.faces.mock.MockVariableResolver;
import com.sun.faces.mock.MockViewHandler;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContextListener;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ResourceHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesListener;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.event.SystemEventListenerHolder;
import javax.faces.validator.Validator;
import javax.servlet.ServletContext;

public class MockApplication
extends Application {
    private static final Logger LOGGER = Logger.getLogger("MockApplication");
    private final SystemEventHelper systemEventHelper = new SystemEventHelper();
    private final ComponentSystemEventHelper compSysEventHelper = new ComponentSystemEventHelper();
    private ServletContext servletContext = null;
    private ActionListener actionListener = null;
    private static boolean processActionCalled = false;
    private NavigationHandler navigationHandler = null;
    private ResourceHandler resourceHandler = new MockResourceHandler();
    private PropertyResolver propertyResolver = null;
    private ExpressionFactory expressionFactory = null;
    private VariableResolver variableResolver = null;
    private ViewHandler viewHandler = null;
    private StateManager stateManager = null;
    private Map components = new HashMap();
    private Map converters = new HashMap();
    private String messageBundle = null;
    private Map validators = new HashMap();

    public MockApplication() {
        this.addComponent("TestNamingContainer", "javax.faces.webapp.TestNamingContainer");
        this.addComponent("TestComponent", "javax.faces.webapp.TestComponent");
        this.addComponent("TestInput", "javax.faces.component.UIInput");
        this.addComponent("TestOutput", "javax.faces.component.UIOutput");
        this.addConverter("Integer", "javax.faces.convert.IntegerConverter");
        this.addConverter("javax.faces.Number", "javax.faces.convert.NumberConverter");
        this.addConverter("javax.faces.Long", "javax.faces.convert.LongConverter");
        this.addValidator("Length", "javax.faces.validator.LengthValidator");
        this.servletContext = new MockServletContext();
    }

    public ActionListener getActionListener() {
        if (null == this.actionListener) {
            this.actionListener = new ActionListener(){

                public void processAction(ActionEvent e) {
                    processActionCalled = true;
                }

                public boolean equals(Object otherObj) {
                    if (!(otherObj instanceof ActionListener)) {
                        return false;
                    }
                    ActionListener other = (ActionListener)otherObj;
                    processActionCalled = false;
                    other.processAction(null);
                    boolean result = processActionCalled;
                    processActionCalled = false;
                    return result;
                }
            };
        }
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public NavigationHandler getNavigationHandler() {
        return this.navigationHandler;
    }

    public void setNavigationHandler(NavigationHandler navigationHandler) {
        this.navigationHandler = navigationHandler;
    }

    public ResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }

    public void setResourceHandler(ResourceHandler resourceHandler) {
        this.resourceHandler = resourceHandler;
    }

    public PropertyResolver getPropertyResolver() {
        if (this.propertyResolver == null) {
            this.propertyResolver = new MockPropertyResolver();
        }
        return this.propertyResolver;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public MethodBinding createMethodBinding(String ref, Class[] params) {
        if (ref == null) {
            throw new NullPointerException();
        }
        return new MockMethodBinding(this, ref, params);
    }

    public ValueBinding createValueBinding(String ref) {
        if (ref == null) {
            throw new NullPointerException();
        }
        return new MockValueBinding(this, ref);
    }

    public void addELResolver(ELResolver resolver) {
    }

    public ELResolver getELResolver() {
        return null;
    }

    public ExpressionFactory getExpressionFactory() {
        if (null == this.expressionFactory) {
            this.expressionFactory = new ExpressionFactoryImpl();
        }
        return this.expressionFactory;
    }

    public Object evaluateExpressionGet(FacesContext context, String expression, Class expectedType) throws ELException {
        ValueExpression ve = this.getExpressionFactory().createValueExpression(context.getELContext(), expression, expectedType);
        return ve.getValue(context.getELContext());
    }

    public VariableResolver getVariableResolver() {
        if (this.variableResolver == null) {
            this.variableResolver = new MockVariableResolver();
        }
        return this.variableResolver;
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        this.variableResolver = variableResolver;
    }

    public ViewHandler getViewHandler() {
        if (null == this.viewHandler) {
            this.viewHandler = new MockViewHandler();
        }
        return this.viewHandler;
    }

    public void setViewHandler(ViewHandler viewHandler) {
        this.viewHandler = viewHandler;
    }

    public StateManager getStateManager() {
        if (null == this.stateManager) {
            this.stateManager = new MockStateManager();
        }
        return this.stateManager;
    }

    public void setStateManager(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    public void addComponent(String componentType, String componentClass) {
        this.components.put(componentType, componentClass);
    }

    public UIComponent createComponent(String componentType) {
        String componentClass = (String)this.components.get(componentType);
        try {
            Class<?> clazz = Class.forName(componentClass);
            return (UIComponent)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public UIComponent createComponent(ValueBinding componentBinding, FacesContext context, String componentType) throws FacesException {
        throw new FacesException((Throwable)new UnsupportedOperationException());
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext context, String componentType) throws FacesException {
        throw new FacesException((Throwable)new UnsupportedOperationException());
    }

    public Iterator getComponentTypes() {
        return this.components.keySet().iterator();
    }

    public void addConverter(String converterId, String converterClass) {
        this.converters.put(converterId, converterClass);
    }

    public void addConverter(Class targetClass, String converterClass) {
        throw new UnsupportedOperationException();
    }

    public Converter createConverter(String converterId) {
        String converterClass = (String)this.converters.get(converterId);
        try {
            Class<?> clazz = Class.forName(converterClass);
            return (Converter)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public Converter createConverter(Class targetClass) {
        throw new UnsupportedOperationException();
    }

    public Iterator getConverterIds() {
        return this.converters.keySet().iterator();
    }

    public Iterator getConverterTypes() {
        throw new UnsupportedOperationException();
    }

    public void setMessageBundle(String messageBundle) {
        this.messageBundle = messageBundle;
    }

    public String getMessageBundle() {
        return this.messageBundle;
    }

    public void addValidator(String validatorId, String validatorClass) {
        this.validators.put(validatorId, validatorClass);
    }

    public Validator createValidator(String validatorId) {
        String validatorClass = (String)this.validators.get(validatorId);
        try {
            Class<?> clazz = Class.forName(validatorClass);
            return (Validator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public Iterator getValidatorIds() {
        return this.validators.keySet().iterator();
    }

    public Iterator getSupportedLocales() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void setSupportedLocales(Collection newLocales) {
    }

    public void addELContextListener(ELContextListener listener) {
    }

    public void removeELContextListener(ELContextListener listener) {
    }

    public ELContextListener[] getELContextListeners() {
        return (ELContextListener[])Array.newInstance(ELContextListener.class, 0);
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public void setDefaultLocale(Locale newLocale) {
    }

    public String getDefaultRenderKitId() {
        return null;
    }

    public void setDefaultRenderKitId(String renderKitId) {
    }

    public ResourceBundle getResourceBundle(FacesContext ctx, String name) {
        return null;
    }

    public void publishEvent(FacesContext context, Class<? extends SystemEvent> systemEventClass, Object source) {
        block4: {
            if (systemEventClass == null) {
                throw new NullPointerException("systemEventClass");
            }
            if (source == null) {
                throw new NullPointerException("source");
            }
            try {
                SystemEvent event = this.invokeComponentListenersFor(systemEventClass, source);
                event = this.invokeListenersFor(systemEventClass, event, source, true);
                this.invokeListenersFor(systemEventClass, event, source, false);
            }
            catch (AbortProcessingException ape) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, ape.getMessage(), ape);
            }
        }
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        if (systemEventClass == null) {
            throw new NullPointerException("systemEventClass");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Set<SystemEventListener> listeners = this.getListeners(systemEventClass, sourceClass);
        listeners.add(listener);
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this.subscribeToEvent(systemEventClass, null, listener);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        if (systemEventClass == null) {
            throw new NullPointerException("systemEventClass");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Set<SystemEventListener> listeners = this.getListeners(systemEventClass, sourceClass);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this.unsubscribeFromEvent(systemEventClass, null, listener);
    }

    private Set<SystemEventListener> getListeners(Class<? extends SystemEvent> systemEvent, Class<?> sourceClass) {
        Set<SystemEventListener> listeners = null;
        EventInfo sourceInfo = this.systemEventHelper.getEventInfo(systemEvent, sourceClass);
        if (sourceInfo != null) {
            listeners = sourceInfo.getListeners();
        }
        return listeners;
    }

    private SystemEvent invokeComponentListenersFor(Class<? extends SystemEvent> systemEventClass, Object source) {
        if (source instanceof SystemEventListenerHolder) {
            EventInfo eventInfo = this.compSysEventHelper.getEventInfo(systemEventClass, source.getClass());
            return this.processListeners(((SystemEventListenerHolder)source).getListenersForEventClass(systemEventClass), null, source, eventInfo);
        }
        return null;
    }

    private SystemEvent invokeListenersFor(Class<? extends SystemEvent> systemEventClass, SystemEvent event, Object source, boolean useSourceLookup) throws AbortProcessingException {
        EventInfo eventInfo = this.systemEventHelper.getEventInfo(systemEventClass, source, useSourceLookup);
        if (eventInfo != null) {
            Set<SystemEventListener> listeners = eventInfo.getListeners();
            event = this.processListeners(listeners, event, source, eventInfo);
        }
        return event;
    }

    private SystemEvent processListeners(Collection<SystemEventListener> listeners, SystemEvent event, Object source, EventInfo eventInfo) {
        if (listeners != null && !listeners.isEmpty()) {
            for (SystemEventListener curListener : listeners) {
                if (!curListener.isListenerForSource(source)) continue;
                if (event == null) {
                    event = eventInfo.createSystemEvent(source);
                }
                assert (event != null);
                if (!event.isAppropriateListener((FacesListener)curListener)) continue;
                event.processListener((FacesListener)curListener);
            }
        }
        return event;
    }

    private static final class Cache<K, V> {
        private ConcurrentMap<K, Future<V>> cache = new ConcurrentHashMap<K, Future<V>>();
        private Factory<K, V> factory;

        public Cache(Factory<K, V> factory) {
            this.factory = factory;
        }

        /*
         * Loose catch block
         */
        public V get(final K key) {
            while (true) {
                Callable callable;
                FutureTask ft;
                FutureTask f;
                if ((f = (FutureTask)this.cache.get(key)) == null && (f = (Future)this.cache.putIfAbsent(key, ft = new FutureTask(callable = new Callable<V>(){

                    @Override
                    public V call() throws Exception {
                        return Cache.this.factory.newInstance(key);
                    }
                }))) == null) {
                    f = ft;
                    ft.run();
                }
                try {
                    return f.get();
                }
                catch (CancellationException ce) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, ce.toString(), ce);
                    }
                    this.cache.remove(key);
                    continue;
                }
                catch (InterruptedException ie) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, ie.toString(), ie);
                    }
                    this.cache.remove(key);
                    continue;
                }
                break;
            }
            catch (ExecutionException ee) {
                throw new FacesException((Throwable)ee);
            }
        }
    }

    private static interface Factory<K, V> {
        public V newInstance(K var1) throws InterruptedException;
    }

    private static class EventInfo {
        private Class<? extends SystemEvent> systemEvent;
        private Class<?> sourceClass;
        private Set<SystemEventListener> listeners;
        private Constructor eventConstructor;
        private Map<Class<?>, Constructor> constructorMap;

        public EventInfo(Class<? extends SystemEvent> systemEvent, Class<?> sourceClass) {
            this.systemEvent = systemEvent;
            this.sourceClass = sourceClass;
            this.listeners = new CopyOnWriteArraySet<SystemEventListener>();
            this.constructorMap = new HashMap();
            if (!sourceClass.equals(Void.class)) {
                this.eventConstructor = this.getEventConstructor(sourceClass);
            }
        }

        public Set<SystemEventListener> getListeners() {
            return this.listeners;
        }

        public SystemEvent createSystemEvent(Object source) {
            Constructor toInvoke = this.getCachedConstructor(source.getClass());
            if (toInvoke != null) {
                try {
                    return (SystemEvent)toInvoke.newInstance(source);
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
            }
            return null;
        }

        private Constructor getCachedConstructor(Class<?> source) {
            if (this.eventConstructor != null) {
                return this.eventConstructor;
            }
            Constructor c = this.constructorMap.get(source);
            if (c == null && (c = this.getEventConstructor(source)) != null) {
                this.constructorMap.put(source, c);
            }
            return c;
        }

        private Constructor getEventConstructor(Class<?> source) {
            Constructor ctor = null;
            try {
                return this.systemEvent.getDeclaredConstructor(source);
            }
            catch (NoSuchMethodException ignored) {
                Constructor<?>[] ctors = this.systemEvent.getConstructors();
                if (ctors != null) {
                    for (Constructor<?> c : ctors) {
                        Class<?>[] params = c.getParameterTypes();
                        if (params.length != 1 || !params[0].isAssignableFrom(source)) continue;
                        return c;
                    }
                }
                if (this.eventConstructor == null && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to find Constructor within {0} that accepts {1} instances.", new Object[]{this.systemEvent.getName(), this.sourceClass.getName()});
                }
                return ctor;
            }
        }
    }

    private static class SystemEventInfo {
        private Cache<Class<?>, EventInfo> cache = new Cache(new Factory<Class<?>, EventInfo>(){

            @Override
            public EventInfo newInstance(Class<?> arg) throws InterruptedException {
                return new EventInfo(SystemEventInfo.this.systemEvent, arg);
            }
        });
        private Class<? extends SystemEvent> systemEvent;

        private SystemEventInfo(Class<? extends SystemEvent> systemEvent) {
            this.systemEvent = systemEvent;
        }

        public EventInfo getEventInfo(Class<?> source) {
            Class sourceClass = source == null ? Void.class : source;
            return this.cache.get(sourceClass);
        }
    }

    private static class ComponentSystemEventHelper {
        private Cache<Class<?>, Cache<Class<? extends SystemEvent>, EventInfo>> sourceCache;

        public ComponentSystemEventHelper() {
            Factory eventCacheFactory = new Factory<Class<?>, Cache<Class<? extends SystemEvent>, EventInfo>>(){

                @Override
                public Cache<Class<? extends SystemEvent>, EventInfo> newInstance(final Class<?> sourceClass) throws InterruptedException {
                    Factory<Class<? extends SystemEvent>, EventInfo> eventInfoFactory = new Factory<Class<? extends SystemEvent>, EventInfo>(){

                        @Override
                        public EventInfo newInstance(Class<? extends SystemEvent> systemEventClass) throws InterruptedException {
                            return new EventInfo(systemEventClass, sourceClass);
                        }
                    };
                    return new Cache<Class<? extends SystemEvent>, EventInfo>(eventInfoFactory);
                }
            };
            this.sourceCache = new Cache(eventCacheFactory);
        }

        public EventInfo getEventInfo(Class<? extends SystemEvent> systemEvent, Class<?> sourceClass) {
            Cache<Class<? extends SystemEvent>, EventInfo> eventsCache = this.sourceCache.get(sourceClass);
            return eventsCache.get(systemEvent);
        }
    }

    private static class SystemEventHelper {
        private final Cache<Class<? extends SystemEvent>, SystemEventInfo> systemEventInfoCache = new Cache<Class<? extends SystemEvent>, SystemEventInfo>(new Factory<Class<? extends SystemEvent>, SystemEventInfo>(){

            @Override
            public SystemEventInfo newInstance(Class<? extends SystemEvent> arg) throws InterruptedException {
                return new SystemEventInfo(arg);
            }
        });

        public EventInfo getEventInfo(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass) {
            EventInfo info = null;
            SystemEventInfo systemEventInfo = this.systemEventInfoCache.get(systemEventClass);
            if (systemEventInfo != null) {
                info = systemEventInfo.getEventInfo(sourceClass);
            }
            return info;
        }

        public EventInfo getEventInfo(Class<? extends SystemEvent> systemEventClass, Object source, boolean useSourceForLookup) {
            Class sourceClass = useSourceForLookup ? source.getClass() : Void.class;
            return this.getEventInfo(systemEventClass, sourceClass);
        }
    }
}

