/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mock;

import com.sun.faces.mock.MockELContext;
import com.sun.faces.mock.MockELResolver;
import com.sun.faces.mock.MockPartialViewContext;
import com.sun.faces.renderkit.RenderKitUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.webapp.PreJsf2ExceptionHandlerFactory;

public class MockFacesContext
extends FacesContext {
    private static final String POST_BACK_MARKER = MockFacesContext.class.getName() + "_POST_BACK";
    private FacesMessage.Severity maxSeverity;
    private Map<Object, Object> attributes = null;
    private PartialViewContext partialView = new MockPartialViewContext();
    private boolean released;
    private Application application = null;
    private PhaseId currentPhaseId = PhaseId.RESTORE_VIEW;
    private ELContext elContext = null;
    private ExternalContext externalContext = null;
    private Locale locale = null;
    private Map<String, List<FacesMessage>> messages = new HashMap<String, List<FacesMessage>>();
    private boolean renderResponse = false;
    private boolean responseComplete = false;
    private ResponseStream responseStream = null;
    private ResponseWriter responseWriter = null;
    private UIViewRoot root = null;
    private ExceptionHandler exceptionHandler = new PreJsf2ExceptionHandlerFactory().getExceptionHandler();
    boolean validationFailed = false;

    public MockFacesContext() {
        MockFacesContext.setCurrentInstance((FacesContext)this);
    }

    public MockFacesContext(ExternalContext externalContext) {
        this.setExternalContext(externalContext);
        MockFacesContext.setCurrentInstance((FacesContext)this);
        this.elContext = new MockELContext(new MockELResolver());
        this.elContext.putContext(FacesContext.class, (Object)this);
    }

    public MockFacesContext(ExternalContext externalContext, Lifecycle lifecycle) {
        this(externalContext);
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Map<Object, Object> getAttributes() {
        if (null == this.attributes) {
            this.attributes = new HashMap<Object, Object>();
        }
        return this.attributes;
    }

    public Iterator getClientIdsWithMessages() {
        return this.messages.keySet().iterator();
    }

    public PhaseId getCurrentPhaseId() {
        return this.currentPhaseId;
    }

    public void setCurrentPhaseId(PhaseId currentPhaseId) {
        this.currentPhaseId = currentPhaseId;
    }

    public ELContext getELContext() {
        return this.elContext;
    }

    public void setELContext(ELContext elContext) {
        this.elContext = elContext;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        return this.maxSeverity;
    }

    public Iterator getMessages() {
        List<FacesMessage> results = this.getMessageList();
        return results.iterator();
    }

    public Iterator getMessages(String clientId) {
        List<FacesMessage> list = this.getMessageList(clientId);
        return list.iterator();
    }

    public List<FacesMessage> getMessageList() {
        ArrayList<FacesMessage> results = new ArrayList<FacesMessage>();
        for (String clientId : this.messages.keySet()) {
            results.addAll(this.messages.get(clientId));
        }
        return results;
    }

    public List<FacesMessage> getMessageList(String clientId) {
        List list = this.messages.get(clientId);
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public RenderKit getRenderKit() {
        UIViewRoot vr = this.getViewRoot();
        if (vr == null) {
            return null;
        }
        String renderKitId = vr.getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        return rkFactory.getRenderKit((FacesContext)this, renderKitId);
    }

    public boolean getRenderResponse() {
        return this.renderResponse;
    }

    public void setRenderResponse(boolean renderResponse) {
        this.renderResponse = renderResponse;
    }

    public boolean getResponseComplete() {
        return this.responseComplete;
    }

    public void setResponseComplete(boolean responseComplete) {
        this.responseComplete = responseComplete;
    }

    public ResponseStream getResponseStream() {
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.responseStream = responseStream;
    }

    public ResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    public UIViewRoot getViewRoot() {
        return this.root;
    }

    public void setViewRoot(UIViewRoot root) {
        this.root = root;
    }

    public boolean isPostback() {
        Boolean postback = (Boolean)this.getAttributes().get(POST_BACK_MARKER);
        if (postback == null) {
            RenderKit rk = this.getRenderKit();
            if (rk != null) {
                postback = rk.getResponseStateManager().isPostback((FacesContext)this);
            } else {
                ViewHandler vh = this.getApplication().getViewHandler();
                String rkId = vh.calculateRenderKitId((FacesContext)this);
                postback = RenderKitUtils.getResponseStateManager((FacesContext)this, (String)rkId).isPostback((FacesContext)this);
            }
            this.getAttributes().put(POST_BACK_MARKER, postback);
        }
        return postback;
    }

    public boolean isReleased() {
        return this.released;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void addMessage(String clientId, FacesMessage message) {
        if (message == null) {
            throw new NullPointerException();
        }
        if (this.maxSeverity == null) {
            this.maxSeverity = message.getSeverity();
        } else {
            FacesMessage.Severity sev = message.getSeverity();
            if (sev.getOrdinal() > this.maxSeverity.getOrdinal()) {
                this.maxSeverity = sev;
            }
        }
        List<FacesMessage> list = this.messages.get(clientId);
        if (list == null) {
            list = new ArrayList<FacesMessage>();
            this.messages.put(clientId, list);
        }
        list.add(message);
    }

    public void release() {
        this.released = true;
        this.application = null;
        this.externalContext = null;
        this.locale = null;
        this.messages.clear();
        this.renderResponse = false;
        this.responseComplete = false;
        this.responseStream = null;
        this.responseWriter = null;
        if (null != this.attributes) {
            this.attributes.clear();
            this.attributes = null;
        }
        this.root = null;
        MockFacesContext.setCurrentInstance(null);
    }

    public void renderResponse() {
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.responseComplete = true;
    }

    public PartialViewContext getPartialViewContext() {
        return this.partialView;
    }

    public void validationFailed() {
        this.validationFailed = true;
    }

    public boolean isValidationFailed() {
        return this.validationFailed;
    }
}

