/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mock;

import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.jsp.JspWriter;

public class MockJspWriter
extends JspWriter {
    StringWriter writer;
    String lineSeparator = System.getProperty("line.separator");
    boolean closed = false;
    boolean flushed = false;

    public MockJspWriter(int bufferSize, boolean autoFlush) {
        super(bufferSize, autoFlush);
        this.writer = new StringWriter(bufferSize);
    }

    public String getBuffer() {
        return this.writer.getBuffer().toString();
    }

    public void clear() throws IOException {
        if (this.flushed) {
            throw new IOException("Already flushed");
        }
        this.writer = new StringWriter(this.getBufferSize());
    }

    public void clearBuffer() throws IOException {
        this.writer = new StringWriter(this.getBufferSize());
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.closed = true;
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.flushed = true;
    }

    public int getRemaining() {
        return this.getBufferSize() - this.writer.getBuffer().length();
    }

    public void newLine() throws IOException {
        this.write(this.lineSeparator);
    }

    public void print(boolean b) throws IOException {
        this.write(b ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(char[] c) throws IOException {
        this.write(c);
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(int i) throws IOException {
        this.write(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(Object o) throws IOException {
        this.write(String.valueOf(o));
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.newLine();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(char[] c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.newLine();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.newLine();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.newLine();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.newLine();
    }

    public void println(Object o) throws IOException {
        this.print(o);
        this.newLine();
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.newLine();
    }

    public void write(char[] c) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.writer.write(c);
    }

    public void write(char[] c, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.writer.write(c, off, len);
    }

    public void write(int c) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.writer.write(c);
    }

    public void write(String s) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.writer.write(s);
    }

    public void write(String s, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.writer.write(s, off, len);
    }
}

