/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mock;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import org.apache.commons.beanutils.PropertyUtils;

public class MockPropertyResolver
extends PropertyResolver {
    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        String name = property.toString();
        try {
            if (base instanceof Map) {
                Map map = (Map)base;
                if (map.containsKey(name)) {
                    return map.get(name);
                }
                throw new PropertyNotFoundException(name);
            }
            return PropertyUtils.getSimpleProperty((Object)base, (String)name);
        }
        catch (IllegalAccessException e) {
            throw new EvaluationException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new EvaluationException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new PropertyNotFoundException(name);
        }
    }

    public Object getValue(Object base, int index) throws PropertyNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void setValue(Object base, Object property, Object value) throws PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        String name = property.toString();
        try {
            if (base instanceof Map) {
                ((Map)base).put(name, value);
            } else {
                PropertyUtils.setSimpleProperty((Object)base, (String)name, (Object)value);
            }
        }
        catch (IllegalAccessException e) {
            throw new EvaluationException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new EvaluationException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new PropertyNotFoundException(name);
        }
    }

    public void setValue(Object base, int index, Object value) throws PropertyNotFoundException {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly(Object base, Object property) throws PropertyNotFoundException {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly(Object base, int index) throws PropertyNotFoundException {
        throw new UnsupportedOperationException();
    }

    public Class getType(Object base, Object property) throws PropertyNotFoundException {
        throw new UnsupportedOperationException();
    }

    public Class getType(Object base, int index) throws PropertyNotFoundException {
        throw new UnsupportedOperationException();
    }
}

