/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mock;

import com.sun.faces.mock.MockResponseStateManager;
import com.sun.faces.mock.MockResponseWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

public class MockRenderKit
extends RenderKit {
    private Map renderers = new HashMap();
    private ResponseStateManager responseStateManager = null;

    public MockRenderKit() {
        this.addRenderer("javax.faces.Data", "javax.faces.Table", new TestRenderer(true));
        this.addRenderer("javax.faces.Input", "TestRenderer", new TestRenderer());
        this.addRenderer("javax.faces.Input", "javax.faces.Text", new TestRenderer());
        this.addRenderer("javax.faces.Output", "TestRenderer", new TestRenderer());
        this.addRenderer("javax.faces.Output", "javax.faces.Text", new TestRenderer());
        this.addRenderer("javax.faces.Panel", "javax.faces.Grid", new TestRenderer(true));
        this.responseStateManager = new MockResponseStateManager();
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        if (family == null || rendererType == null || renderer == null) {
            throw new NullPointerException();
        }
        this.renderers.put(family + "|" + rendererType, renderer);
    }

    public Renderer getRenderer(String family, String rendererType) {
        if (family == null || rendererType == null) {
            throw new NullPointerException();
        }
        return (Renderer)this.renderers.get(family + "|" + rendererType);
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        return new MockResponseWriter(writer, characterEncoding);
    }

    public ResponseStream createResponseStream(OutputStream out) {
        final OutputStream os = out;
        return new ResponseStream(){

            public void close() throws IOException {
                os.close();
            }

            public void flush() throws IOException {
                os.flush();
            }

            public void write(byte[] b) throws IOException {
                os.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                os.write(b, off, len);
            }

            public void write(int b) throws IOException {
                os.write(b);
            }
        };
    }

    public ResponseStateManager getResponseStateManager() {
        return this.responseStateManager;
    }

    class TestRenderer
    extends Renderer {
        private boolean rendersChildren = false;

        public TestRenderer() {
        }

        public TestRenderer(boolean rendersChildren) {
            this.rendersChildren = rendersChildren;
        }

        public void decode(FacesContext context, UIComponent component) {
            if (context == null || component == null) {
                throw new NullPointerException();
            }
            if (!(component instanceof UIInput)) {
                return;
            }
            UIInput input = (UIInput)component;
            String clientId = input.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            if (params.containsKey(clientId)) {
                input.setSubmittedValue((Object)((String)params.get(clientId)));
            }
        }

        public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
            if (context == null || component == null) {
                throw new NullPointerException();
            }
            ResponseWriter writer = context.getResponseWriter();
            writer.write("<text id='" + component.getClientId(context) + "' value='" + component.getAttributes().get("value") + "'/>\n");
        }

        public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
            if (context == null || component == null) {
                throw new NullPointerException();
            }
        }

        public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
            if (context == null || component == null) {
                throw new NullPointerException();
            }
        }
    }
}

