/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;

final class MockSessionMap
implements Map {
    private HttpSession session = null;

    public MockSessionMap(HttpSession session) {
        this.session = session;
    }

    @Override
    public void clear() {
        Iterator keys = this.keySet().iterator();
        while (keys.hasNext()) {
            this.session.removeAttribute((String)keys.next());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.session.getAttribute(this.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Enumeration keys = this.session.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object next = this.session.getAttribute((String)keys.nextElement());
            if (next != value) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashSet<Object> set = new HashSet<Object>();
        Enumeration keys = this.session.getAttributeNames();
        while (keys.hasMoreElements()) {
            set.add(this.session.getAttribute((String)keys.nextElement()));
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        return this.session.equals(o);
    }

    public Object get(Object key) {
        return this.session.getAttribute(this.key(key));
    }

    @Override
    public int hashCode() {
        return this.session.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    public Set keySet() {
        HashSet set = new HashSet();
        Enumeration keys = this.session.getAttributeNames();
        while (keys.hasMoreElements()) {
            set.add(keys.nextElement());
        }
        return set;
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        String skey = this.key(key);
        Object previous = this.session.getAttribute(skey);
        this.session.setAttribute(skey, value);
        return previous;
    }

    public void putAll(Map map) {
        for (String key : map.keySet()) {
            this.session.setAttribute(key, map.get(key));
        }
    }

    public Object remove(Object key) {
        String skey = this.key(key);
        Object previous = this.session.getAttribute(skey);
        this.session.removeAttribute(skey);
        return previous;
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration keys = this.session.getAttributeNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    public Collection values() {
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration keys = this.session.getAttributeNames();
        while (keys.hasMoreElements()) {
            list.add(this.session.getAttribute((String)keys.nextElement()));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

