/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.poormans_installer.builder;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.kohsuke.sfx4j.Packager;

public class Main {
    static /* synthetic */ Class class$org$jvnet$poormans_installer$builder$Main;

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Usage: InstallerBuilder <license file> <distribution package zip> <output class file>");
            return;
        }
        Main.build(new File(args[0]), new File(args[1]), new File(args[2]));
    }

    public static void build(File license, File zip, File classFile) throws Exception {
        File tmpDir = File.createTempFile("foo", "bar");
        tmpDir.delete();
        tmpDir.mkdir();
        File rawInstaller = new File(tmpDir, "raw-installer.jar");
        Main.copyStream((class$org$jvnet$poormans_installer$builder$Main == null ? (class$org$jvnet$poormans_installer$builder$Main = Main.class$("org.jvnet.poormans_installer.builder.Main")) : class$org$jvnet$poormans_installer$builder$Main).getResourceAsStream("/raw-installer.jar"), new FileOutputStream(rawInstaller));
        File sandbox = new File(tmpDir, "sandbox");
        sandbox.mkdir();
        Main.run(sandbox, new String[]{"jar", "xf", rawInstaller.getAbsolutePath()});
        Main.copyStream(new FileInputStream(license), new FileOutputStream(new File(sandbox, "license.txt")));
        Main.copyStream(new FileInputStream(zip), new FileOutputStream(new File(sandbox, "package.zip")));
        File manifest = new File(tmpDir, "MANIFEST.MF");
        BufferedWriter w = new BufferedWriter(new FileWriter(manifest));
        w.write("Main-Class: org.jvnet.poormans_installer.Main");
        w.newLine();
        w.close();
        new File(new File(sandbox, "META-INF"), "MANIFEST.MF").delete();
        Main.run(tmpDir, new String[]{"jar", "cfm", "installer.jar", "MANIFEST.MF", "-C", sandbox.toString(), "."});
        Packager.main(new String[]{new File(tmpDir, "installer.jar").getAbsolutePath(), classFile.getAbsolutePath()});
        Main.recursiveDelete(tmpDir);
    }

    private static void run(File workDir, String[] cmdLine) throws Exception {
        Process proc = Runtime.getRuntime().exec(cmdLine, new String[0], workDir);
        new Thread(new ProcessReader(proc.getInputStream())).start();
        new Thread(new ProcessReader(proc.getErrorStream())).start();
        if (proc.waitFor() != 0) {
            throw new Exception("failed to execute " + cmdLine);
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[256];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    public static void recursiveDelete(File f) {
        if (f.isDirectory()) {
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                Main.recursiveDelete(new File(f, files[i]));
            }
        }
        f.delete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ProcessReader
    implements Runnable {
        private final BufferedReader reader;

        ProcessReader(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader(is));
        }

        public void run() {
            try {
                while (true) {
                    String s;
                    if ((s = this.reader.readLine()) == null) {
                        this.reader.close();
                        return;
                    }
                    System.out.println(s);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Error();
            }
        }
    }
}

