/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.htmlunit;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public abstract class HtmlUnitFacesTestCase
extends TestCase {
    protected static final Logger log = Logger.getLogger(HtmlUnitFacesTestCase.class.getName());
    protected String testName;
    protected String contextPath = null;
    protected String host = null;
    protected int port = 0;
    protected Integer virtualServerPort = null;
    protected String sessionId = null;
    protected WebClient client = null;
    protected URL domainURL = null;
    protected CookieManager cmanager = null;
    protected HtmlPage lastpage = null;
    protected Map<Container, Vector<String>> exclusions = null;
    private List<Integer> instanceNumbers;
    protected boolean forceNoCluster = false;
    private Random rand = new Random();
    protected boolean isVirtualServer = false;

    public HtmlUnitFacesTestCase(String name) {
        super(name);
        this.testName = name;
    }

    public void setUp() throws Exception {
        String forceNoClusterStr;
        this.isVirtualServer = Boolean.parseBoolean(System.getProperty("virtual-server"));
        String instanceNumbersStr = System.getProperty("instance.numbers");
        if (null != instanceNumbersStr && 0 < instanceNumbersStr.length() && !"${instance.numbers}".equals(instanceNumbersStr)) {
            String[] strs = instanceNumbersStr.split(",");
            List<Integer> instNums = this.getInstanceNumbers();
            for (String cur : strs) {
                try {
                    instNums.add(Integer.parseInt(cur));
                }
                catch (NumberFormatException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        this.forceNoCluster = null != (forceNoClusterStr = System.getProperty("force.no.cluster")) && 0 < forceNoClusterStr.length();
        this.contextPath = System.getProperty("context.path");
        this.host = System.getProperty("host");
        this.port = Integer.parseInt(System.getProperty("port"));
        String browser = System.getProperty("browser");
        BrowserVersion browserVersion = "FF3".equals(browser) ? BrowserVersion.FIREFOX_3 : ("FF2".equals(browser) ? BrowserVersion.FIREFOX_2 : ("IE6".equals(browser) ? BrowserVersion.INTERNET_EXPLORER_6 : BrowserVersion.INTERNET_EXPLORER_7));
        String proxyHost = System.getProperty("proxyHost");
        String proxyPort = System.getProperty("proxyPort");
        this.client = new WebClient(browserVersion);
        this.cmanager = this.client.getCookieManager();
        this.client.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
        this.domainURL = this.getURL("/");
        WebRequestSettings settings = new WebRequestSettings(this.domainURL);
        if (null != proxyHost && null != proxyPort) {
            settings.setProxyHost(proxyHost);
            int proxyPortInt = Integer.parseInt(proxyPort);
            settings.setProxyPort(proxyPortInt);
            ProxyConfig config = this.client.getProxyConfig();
            config.setProxyHost(proxyHost);
            config.setProxyPort(proxyPortInt);
        }
        WebResponse response = this.client.getWebConnection().getResponse(settings);
    }

    protected List<Integer> getInstanceNumbers() {
        if (null == this.instanceNumbers) {
            this.instanceNumbers = new ArrayList<Integer>();
        }
        return this.instanceNumbers;
    }

    public static Test suite() {
        return new TestSuite(HtmlUnitFacesTestCase.class);
    }

    public void tearDown() {
        this.client = null;
        this.domainURL = null;
        this.cmanager = null;
    }

    protected String getBodyText(HtmlPage page) {
        Object body = page.getDocumentElement().getHtmlElementsByTagName("body").get(0);
        if (body != null && body instanceof HtmlBody) {
            return ((HtmlBody)body).asText();
        }
        HtmlUnitFacesTestCase.fail((String)"This page does not have a <body> element");
        return null;
    }

    protected HtmlPage getPage(String path) throws Exception {
        this.lastpage = (HtmlPage)this.client.getPage(this.getURL(path));
        if (this.sessionId == null) {
            this.parseSession(this.lastpage);
        }
        return this.lastpage;
    }

    protected HtmlPage getPageWithRetry(String path, int retries) throws Exception {
        int i = 0;
        boolean success = false;
        do {
            try {
                this.getPage(path);
                success = true;
            }
            catch (FailingHttpStatusCodeException fhse) {
                Thread.sleep(3000L);
            }
        } while (!success && ++i < retries);
        return this.lastpage;
    }

    protected HtmlPage getPageSticky(String path) throws Exception {
        this.lastpage = (HtmlPage)this.client.getPage(this.getURLSticky(path));
        if (this.sessionId == null) {
            this.parseSession(this.lastpage);
        }
        return this.lastpage;
    }

    protected HtmlPage getPageFromInstanceN(String path, int instanceNumber) throws Exception {
        this.lastpage = (HtmlPage)this.client.getPage(this.getURLFromInstanceN(path, instanceNumber));
        if (this.sessionId == null) {
            this.parseSession(this.lastpage);
        }
        return this.lastpage;
    }

    protected int getPort() {
        if (null != this.virtualServerPort) {
            return this.virtualServerPort;
        }
        int result = this.port;
        List<Integer> instNums = this.getInstanceNumbers();
        if (!(instNums.isEmpty() || this.forceNoCluster && !this.isVirtualServer)) {
            int instanceNumberIndex = this.rand.nextInt(instNums.size());
            try {
                String num = instNums.get(instanceNumberIndex).toString() + this.port;
                result = Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                System.out.println(e.getMessage());
                throw e;
            }
        }
        if (this.isVirtualServer) {
            this.virtualServerPort = result;
        }
        return result;
    }

    protected int getFirstPort() {
        int result = this.port;
        List<Integer> instNums = this.getInstanceNumbers();
        if (!instNums.isEmpty() && !this.forceNoCluster) {
            int instanceNumberIndex = 0;
            try {
                String num = instNums.get(instanceNumberIndex).toString() + this.port;
                result = Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                System.out.println(e.getMessage());
                throw e;
            }
        }
        return result;
    }

    protected int getNthPort(int instanceNumber) {
        int result = this.port;
        if (!this.forceNoCluster) {
            try {
                String num = instanceNumber + "" + this.port;
                result = Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                System.out.println(e.getMessage());
                throw e;
            }
        }
        return result;
    }

    protected HtmlPage getPage(String path, WebClient client) throws Exception {
        this.lastpage = (HtmlPage)client.getPage(this.getURL(path));
        if (this.sessionId == null) {
            this.parseSession(this.lastpage);
        }
        return this.lastpage;
    }

    protected URL getURL(String path) throws Exception {
        StringBuffer sb = new StringBuffer("http://");
        sb.append(this.host);
        int myPort = this.getPort();
        if (myPort != 80) {
            sb.append(":");
            sb.append("" + myPort);
        }
        sb.append(this.contextPath);
        sb.append(path);
        if (log.isLoggable(Level.INFO)) {
            log.info(sb.toString());
        }
        return new URL(sb.toString());
    }

    protected URL getURLSticky(String path) throws Exception {
        StringBuffer sb = new StringBuffer("http://");
        sb.append(this.host);
        int myPort = this.getFirstPort();
        if (myPort != 80) {
            sb.append(":");
            sb.append("" + myPort);
        }
        sb.append(this.contextPath);
        sb.append(path);
        if (log.isLoggable(Level.INFO)) {
            log.info(sb.toString());
        }
        return new URL(sb.toString());
    }

    protected URL getURLFromInstanceN(String path, int instanceNumber) throws Exception {
        StringBuilder sb = new StringBuilder("http://");
        sb.append(this.host);
        int myPort = this.getNthPort(instanceNumber);
        if (myPort != 80) {
            sb.append(":");
            sb.append("").append(myPort);
        }
        sb.append(this.contextPath);
        sb.append(path);
        if (log.isLoggable(Level.INFO)) {
            log.info(sb.toString());
        }
        return new URL(sb.toString());
    }

    protected void parseSession(HtmlPage page) {
        String value = page.getWebResponse().getResponseHeaderValue("Set-Cookie");
        if (value == null) {
            return;
        }
        int equals = value.indexOf("JSESSIONID=");
        if (equals < 0) {
            return;
        }
        int semi = (value = value.substring(equals + "JSESSIONID=".length())).indexOf(";");
        if (semi >= 0) {
            value = value.substring(0, semi);
        }
        this.sessionId = value;
    }

    protected boolean clearAllCookies() {
        this.cmanager.clearCookies();
        return true;
    }

    protected HtmlForm getFormById(HtmlPage page, String id) {
        for (HtmlForm form : page.getForms()) {
            if (!id.equals(form.getAttributeValue("id"))) continue;
            return form;
        }
        return null;
    }

    protected List getAllElementsOfGivenClass(HtmlPage root, List list, Class matchClass) {
        return this.getAllElementsOfGivenClass(root.getDocumentElement(), list, matchClass);
    }

    protected List getAllElementsOfGivenClass(HtmlElement root, List list, Class matchClass) {
        if (null == root) {
            return list;
        }
        if (null == list) {
            list = new ArrayList<HtmlElement>();
        }
        Iterable iterable = root.getAllHtmlChildElements();
        Iterator iter = iterable.iterator();
        while (iter.hasNext()) {
            this.getAllElementsOfGivenClass((HtmlElement)iter.next(), list, matchClass);
        }
        if (matchClass.isInstance(root) && !list.contains(root)) {
            list.add(root);
        }
        return list;
    }

    protected HtmlInput getInputContainingGivenId(HtmlPage root, String id) {
        HtmlInput result = null;
        List list = this.getAllElementsOfGivenClass(root, null, HtmlInput.class);
        for (int i = 0; i < list.size() && -1 == (result = (HtmlInput)list.get(i)).getIdAttribute().indexOf(id); ++i) {
            result = null;
        }
        return result;
    }

    protected HtmlInput getNthInputContainingGivenId(HtmlPage root, String id, int whichInput) {
        int hitCount = 0;
        HtmlInput result = null;
        List list = this.getAllElementsOfGivenClass(root, null, HtmlInput.class);
        for (int i = 0; i < list.size() && (-1 == (result = (HtmlInput)list.get(i)).getIdAttribute().indexOf(id) || hitCount++ != whichInput); ++i) {
            result = null;
        }
        return result;
    }

    protected HtmlInput getNthFromLastInputContainingGivenId(HtmlPage root, String id, int whichInput) {
        int hitCount = 0;
        HtmlInput result = null;
        List list = this.getAllElementsOfGivenClass(root, null, HtmlInput.class);
        for (int i = list.size() - 1; i >= 0 && (-1 == (result = (HtmlInput)list.get(i)).getIdAttribute().indexOf(id) || hitCount++ != whichInput); --i) {
            result = null;
        }
        return result;
    }

    protected String getText(String element) {
        return this.lastpage.getHtmlElementById(element).asText();
    }

    protected boolean check(String element, String expected) {
        return expected.equals(this.getText(element));
    }

    protected void checkTrue(String element, String expected) {
        HtmlUnitFacesTestCase.assertTrue((String)(element + ":- Expected '" + expected + "', but received '" + this.getText(element) + "'"), (boolean)this.check(element, expected));
    }

    protected void runTest() throws Throwable {
        Vector<String> excludedTests;
        String currentContainer = System.getProperty("container");
        boolean doRunTest = true;
        if (currentContainer == null) {
            log.warning("Test exclusions not taken into account since no container property could be found");
        } else if (this.exclusions != null && null != (excludedTests = this.exclusions.get((Object)Container.valueOf(currentContainer.toUpperCase().replaceAll("\\.", "_")))) && !excludedTests.isEmpty() && excludedTests.contains(this.testName)) {
            log.log(Level.INFO, "Skipping execution of test ''{0}'' for container {1}", new Object[]{this.testName, currentContainer});
            doRunTest = false;
        }
        if (doRunTest) {
            super.runTest();
        }
    }

    protected void addExclusion(Container container, String testName) {
        Vector<String> excluded;
        if (this.exclusions == null) {
            this.exclusions = new HashMap<Container, Vector<String>>();
        }
        if ((excluded = this.exclusions.get((Object)container)) == null) {
            excluded = new Vector();
            this.exclusions.put(container, excluded);
        }
        excluded.add(testName);
    }

    protected static enum Container {
        GLASSFISH,
        GLASSFISHV3PRELUDE,
        GLASSFISHV3,
        GLASSFISHV3_1,
        GLASSFISHV3_1_NO_CLUSTER,
        TOMCAT6,
        TOMCAT7,
        WLS_10_3_4_NO_CLUSTER,
        WLS_12_1_1_NO_CLUSTER;

    }
}

