/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mock;

import com.sun.faces.mock.MockEnumeration;
import com.sun.faces.mock.MockPrincipal;
import java.io.BufferedReader;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class MockHttpServletRequest
implements HttpServletRequest {
    protected HashMap attributes = new HashMap();
    protected String contextPath = null;
    protected Locale locale = null;
    protected HashMap parameters = new HashMap();
    protected String pathInfo = null;
    protected Principal principal = null;
    protected String queryString = null;
    protected String servletPath = null;
    protected HttpSession session = null;
    protected String method = "GET";

    public MockHttpServletRequest() {
    }

    public MockHttpServletRequest(HttpSession session) {
        this.setHttpSession(session);
    }

    public MockHttpServletRequest(String contextPath, String servletPath, String pathInfo, String queryString) {
        this.setPathElements(contextPath, servletPath, pathInfo, queryString);
    }

    public MockHttpServletRequest(String contextPath, String servletPath, String pathInfo, String queryString, HttpSession session) {
        this.setPathElements(contextPath, servletPath, pathInfo, queryString);
        this.setHttpSession(session);
    }

    public void addParameter(String name, String value) {
        String[] values = (String[])this.parameters.get(name);
        if (values == null) {
            String[] results = new String[]{value};
            this.parameters.put(name, results);
            return;
        }
        String[] results = new String[values.length + 1];
        System.arraycopy(values, 0, results, 0, values.length);
        results[values.length] = value;
        this.parameters.put(name, results);
    }

    public void setHttpSession(HttpSession session) {
        this.session = session;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setPathElements(String contextPath, String servletPath, String pathInfo, String queryString) {
        this.contextPath = contextPath;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
    }

    public void setUserPrincipal(Principal principal) {
        this.principal = principal;
    }

    public String getAuthType() {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        throw new UnsupportedOperationException();
    }

    public long getDateHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public Enumeration getHeaderNames() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getHeaders(String name) {
        throw new UnsupportedOperationException();
    }

    public int getIntHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        if (this.principal != null) {
            return this.principal.getName();
        }
        return null;
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    public String getRequestURI() {
        StringBuffer sb = new StringBuffer();
        if (this.contextPath != null) {
            sb.append(this.contextPath);
        }
        if (this.servletPath != null) {
            sb.append(this.servletPath);
        }
        if (this.pathInfo != null) {
            sb.append(this.pathInfo);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        throw new UnsupportedOperationException();
    }

    public StringBuffer getRequestURL() {
        throw new UnsupportedOperationException();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (create && this.session == null) {
            throw new UnsupportedOperationException();
        }
        return this.session;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        if (this.principal != null && this.principal instanceof MockPrincipal) {
            return ((MockPrincipal)this.principal).isUserInRole(role);
        }
        return false;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new MockEnumeration(this.attributes.keySet().iterator());
    }

    public String getCharacterEncoding() {
        return "ISO-8859-1";
    }

    public int getContentLength() {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        return "text/html";
    }

    public ServletInputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getLocales() {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Enumeration getParameterNames() {
        return new MockEnumeration(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    public BufferedReader getReader() {
        throw new UnsupportedOperationException();
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        throw new UnsupportedOperationException();
    }

    public String getRemoteHost() {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return "localhost";
    }

    public int getServerPort() {
        return 8080;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void setCharacterEncoding(String name) {
        throw new UnsupportedOperationException();
    }
}

