/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mock;

import com.sun.faces.mock.MockJspWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.el.ELContext;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;

public class MockPageContext
extends PageContext {
    private Servlet servlet = null;
    private ServletRequest request = null;
    private ServletResponse response = null;
    private HttpSession session = null;
    private String errorPageURL = null;
    private boolean needsSession = false;
    private int bufferSize = 0;
    private boolean autoFlush = false;
    private ServletConfig config = null;
    private ServletContext context = null;
    private JspWriter out = null;
    private Hashtable attributes = new Hashtable();

    public void clearPageScope() {
        this.attributes.clear();
    }

    public ELContext getELContext() {
        return null;
    }

    public Object findAttribute(String name) {
        Object value = this.attributes.get(name);
        if (value == null) {
            value = this.request.getAttribute(name);
        }
        if (value == null && this.session != null) {
            value = this.session.getAttribute(name);
        }
        if (value == null) {
            value = this.context.getAttribute(name);
        }
        return value;
    }

    public void forward(String path) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 1);
    }

    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                return this.attributes.get(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("No session for this request");
                }
                return this.session.getAttribute(name);
            }
            case 4: {
                return this.context.getAttribute(name);
            }
        }
        throw new IllegalArgumentException("Invalid scope " + scope);
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return this.attributes.keys();
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("No session for this request");
                }
                return this.session.getAttributeNames();
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        throw new IllegalArgumentException("Invalid scope " + scope);
    }

    public int getAttributesScope(String name) {
        if (this.attributes.get(name) != null) {
            return 1;
        }
        if (this.request.getAttribute(name) != null) {
            return 2;
        }
        if (this.session != null && this.session.getAttribute(name) != null) {
            return 3;
        }
        if (this.context.getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    public Exception getException() {
        return (Exception)this.request.getAttribute("javax.servlet.jsp.jspException");
    }

    public JspWriter getOut() {
        return this.out;
    }

    public Object getPage() {
        return this.servlet;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        throw new UnsupportedOperationException();
    }

    public void handlePageException(Exception e) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void handlePageException(Throwable t) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void include(String path) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
        this.servlet = servlet;
        this.request = request;
        this.response = response;
        this.errorPageURL = errorPageURL;
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        if (request instanceof HttpServletRequest && needsSession) {
            this.session = ((HttpServletRequest)request).getSession();
        }
        this.out = new MockJspWriter(bufferSize, autoFlush);
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", this.request);
        this.setAttribute("javax.servlet.jsp.jspResponse", this.response);
        if (this.session != null) {
            this.setAttribute("javax.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("javax.servlet.jsp.jspPage", servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.config);
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.context);
    }

    public VariableResolver getVariableResolver() {
        throw new UnsupportedOperationException();
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        throw new UnsupportedOperationException();
    }

    public JspWriter popBody() {
        throw new UnsupportedOperationException();
    }

    public BodyContent pushBody() {
        throw new UnsupportedOperationException();
    }

    public void release() {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 1);
    }

    public void removeAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                this.attributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("No session for this request");
                }
                this.session.removeAttribute(name);
                break;
            }
            case 4: {
                this.context.removeAttribute(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope " + scope);
            }
        }
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 1);
    }

    public void setAttribute(String name, Object value, int scope) {
        switch (scope) {
            case 1: {
                this.attributes.put(name, value);
                break;
            }
            case 2: {
                this.request.setAttribute(name, value);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("No session for this request");
                }
                this.session.setAttribute(name, value);
                break;
            }
            case 4: {
                this.context.setAttribute(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope " + scope);
            }
        }
    }
}

