/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make.calltree;

import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Constants;
import aQute.lib.osgi.WriteResource;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalltreeResource
extends WriteResource {
    Collection<Clazz> classes;

    public CalltreeResource(Collection<Clazz> values) {
        this.classes = values;
        System.out.println(values);
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public void write(OutputStream out) throws Exception {
        OutputStreamWriter osw = new OutputStreamWriter(out, Constants.DEFAULT_CHARSET);
        PrintWriter pw = new PrintWriter(osw);
        try {
            CalltreeResource.writeCalltree(pw, this.classes);
        }
        finally {
            pw.flush();
        }
    }

    public static void writeCalltree(PrintWriter out, Collection<Clazz> classes) throws Exception {
        final TreeMap<Clazz.MethodDef, Set<Clazz.MethodDef>> using = new TreeMap<Clazz.MethodDef, Set<Clazz.MethodDef>>();
        final TreeMap<Clazz.MethodDef, Set<Clazz.MethodDef>> usedby = new TreeMap<Clazz.MethodDef, Set<Clazz.MethodDef>>();
        ClassDataCollector cd = new ClassDataCollector(){
            Clazz.MethodDef source;

            public void method(Clazz.MethodDef source) {
                this.source = source;
                CalltreeResource.xref(using, source, null);
                CalltreeResource.xref(usedby, source, null);
            }

            public void reference(Clazz.MethodDef reference) {
                CalltreeResource.xref(using, this.source, reference);
                CalltreeResource.xref(usedby, reference, this.source);
            }
        };
        for (Clazz clazz : classes) {
            clazz.parseClassFileWithCollector(cd);
        }
        out.println("<calltree>");
        CalltreeResource.xref(out, "using", using);
        CalltreeResource.xref(out, "usedby", usedby);
        out.println("</calltree>");
    }

    private static void xref(Map<Clazz.MethodDef, Set<Clazz.MethodDef>> references, Clazz.MethodDef source, Clazz.MethodDef reference) {
        Set<Clazz.MethodDef> set = references.get(source);
        if (set == null) {
            set = new TreeSet<Clazz.MethodDef>();
            references.put(source, set);
        }
        if (reference != null) {
            set.add(reference);
        }
    }

    private static void xref(PrintWriter out, String group, Map<Clazz.MethodDef, Set<Clazz.MethodDef>> references) {
        out.println("  <" + group + ">");
        for (Map.Entry<Clazz.MethodDef, Set<Clazz.MethodDef>> entry : references.entrySet()) {
            Clazz.MethodDef source = entry.getKey();
            Set<Clazz.MethodDef> refs = entry.getValue();
            CalltreeResource.method(out, "method", source, ">");
            for (Clazz.MethodDef ref : refs) {
                CalltreeResource.method(out, "ref", ref, "/>");
            }
            out.println("      </method>");
        }
        out.println("  </" + group + ">");
    }

    private static void method(PrintWriter out, String element, Clazz.MethodDef source, String closeElement) {
        out.println("      <" + element + " class='" + source.clazz + "'" + CalltreeResource.getAccess(source.access) + (source.isConstructor() ? "" : " name='" + source.name + "'") + " descriptor='" + source.descriptor + "' pretty='" + source.getPretty() + "'" + closeElement);
    }

    private static String getAccess(int access) {
        StringBuilder sb = new StringBuilder();
        if (Modifier.isPublic(access)) {
            sb.append(" public='true'");
        }
        if (Modifier.isStatic(access)) {
            sb.append(" static='true'");
        }
        if (Modifier.isProtected(access)) {
            sb.append(" protected='true'");
        }
        if (Modifier.isInterface(access)) {
            sb.append(" interface='true'");
        }
        return sb.toString();
    }
}

