/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make.metatype;

import aQute.bnd.annotation.metatype.Configurable;
import aQute.bnd.annotation.metatype.Meta;
import aQute.lib.io.IO;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Annotation;
import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Resource;
import aQute.lib.tag.Tag;
import aQute.libg.generics.Create;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaTypeReader
extends ClassDataCollector
implements Resource {
    final Analyzer reporter;
    Clazz clazz;
    String[] interfaces;
    Tag metadata = new Tag("metatype:MetaData", new String[]{"xmlns:metatype", "http://www.osgi.org/xmlns/metatype/v1.1.0"});
    Tag ocd = new Tag(this.metadata, "OCD", new Object[0]);
    Tag designate = new Tag(this.metadata, "Designate", new Object[0]);
    Tag object = new Tag(this.designate, "Object", new Object[0]);
    String extra;
    boolean finished;
    boolean override;
    String designatePid;
    boolean factory;
    Map<Clazz.MethodDef, Meta.AD> methods = new LinkedHashMap<Clazz.MethodDef, Meta.AD>();
    Annotation ocdAnnotation;
    Clazz.MethodDef method;
    static Pattern COLLECTION = Pattern.compile("(.*(Collection|Set|List|Queue|Stack|Deque))<(L.+;)>");

    public MetaTypeReader(Clazz clazz, Analyzer reporter) {
        this.clazz = clazz;
        this.reporter = reporter;
    }

    public void annotation(Annotation annotation) {
        try {
            Meta.OCD ocd = annotation.getAnnotation(Meta.OCD.class);
            Meta.AD ad = annotation.getAnnotation(Meta.AD.class);
            if (ocd != null) {
                this.ocdAnnotation = annotation;
            }
            if (ad != null) {
                assert (this.method != null);
                this.methods.put(this.method, ad);
            }
        }
        catch (Exception e) {
            this.reporter.error("Error during annotation parsing %s : %s", this.clazz, e);
            e.printStackTrace();
        }
    }

    private void addMethod(Clazz.MethodDef method, Meta.AD ad) throws Exception {
        String rtype = method.getReturnType();
        String id = Configurable.mangleMethodName(method.name);
        String name = Clazz.unCamel(id);
        int cardinality = 0;
        if (rtype.endsWith("[]")) {
            cardinality = Integer.MAX_VALUE;
            rtype = rtype.substring(0, rtype.length() - 2);
        }
        if (rtype.indexOf(60) > 0) {
            Matcher m;
            if (cardinality != 0) {
                this.reporter.error("AD for %s.%s uses an array of collections in return type (%s), Metatype allows either Vector or array", this.clazz.getFQN(), method.name, method.getReturnType());
            }
            if ((m = COLLECTION.matcher(rtype)).matches()) {
                rtype = Clazz.objectDescriptorToFQN(m.group(3));
                cardinality = Integer.MIN_VALUE;
            }
        }
        Meta.Type type = this.getType(rtype);
        boolean required = ad == null || ad.required();
        String deflt = null;
        String max = null;
        String min = null;
        String[] optionLabels = null;
        String[] optionValues = null;
        String description = null;
        Clazz c = this.reporter.findClass(Clazz.fqnToPath(rtype));
        if (c != null && c.isEnum()) {
            optionValues = this.parseOptionValues(c);
        }
        if (ad != null) {
            if (ad.id() != null) {
                id = ad.id();
            }
            if (ad.name() != null) {
                name = ad.name();
            }
            if (ad.cardinality() != 0) {
                cardinality = ad.cardinality();
            }
            if (ad.type() != null) {
                type = ad.type();
            }
            if (ad.required() || ad.deflt() == null) {
                required = true;
            }
            if (ad.description() != null) {
                description = ad.description();
            }
            if (ad.optionLabels() != null) {
                optionLabels = ad.optionLabels();
            }
            if (ad.optionValues() != null) {
                optionValues = ad.optionValues();
            }
            if (ad.min() != null) {
                min = ad.min();
            }
            if (ad.max() != null) {
                max = ad.max();
            }
            if (ad.deflt() != null) {
                deflt = ad.deflt();
            }
        }
        if (optionValues != null) {
            if (optionLabels == null || optionLabels.length == 0) {
                optionLabels = new String[optionValues.length];
                int i = 0;
                while (i < optionValues.length) {
                    optionLabels[i] = Clazz.unCamel(optionValues[i]);
                    ++i;
                }
            }
            if (optionLabels.length != optionValues.length) {
                this.reporter.error("Option labels and option values not the same length for %s", id);
                optionLabels = optionValues;
            }
        }
        Tag adt = new Tag(this.ocd, "AD", new Object[0]);
        adt.addAttribute("name", name);
        adt.addAttribute("id", id);
        adt.addAttribute("cardinality", cardinality);
        adt.addAttribute("required", required);
        adt.addAttribute("default", deflt);
        adt.addAttribute("type", (Object)type);
        adt.addAttribute("max", max);
        adt.addAttribute("min", min);
        adt.addAttribute("description", description);
        if (optionLabels != null) {
            int i = 0;
            while (i < optionLabels.length) {
                Tag option = new Tag(adt, "Option", new Object[0]);
                option.addAttribute("label", optionLabels[i]);
                option.addAttribute("value", optionValues[i]);
                ++i;
            }
        }
    }

    private String[] parseOptionValues(Clazz c) throws Exception {
        final List<String> values = Create.list();
        c.parseClassFileWithCollector(new ClassDataCollector(){

            public void field(Clazz.FieldDef def) {
                if (def.isEnum()) {
                    values.add(def.name);
                }
            }
        });
        return values.toArray(new String[values.size()]);
    }

    Meta.Type getType(String rtype) {
        if (rtype.endsWith("[]") && (rtype = rtype.substring(0, rtype.length() - 2)).endsWith("[]")) {
            throw new IllegalArgumentException("Can only handle array of depth one");
        }
        if ("boolean".equals(rtype) || Boolean.class.getName().equals(rtype)) {
            return Meta.Type.Boolean;
        }
        if ("byte".equals(rtype) || Byte.class.getName().equals(rtype)) {
            return Meta.Type.Byte;
        }
        if ("char".equals(rtype) || Character.class.getName().equals(rtype)) {
            return Meta.Type.Character;
        }
        if ("short".equals(rtype) || Short.class.getName().equals(rtype)) {
            return Meta.Type.Short;
        }
        if ("int".equals(rtype) || Integer.class.getName().equals(rtype)) {
            return Meta.Type.Integer;
        }
        if ("long".equals(rtype) || Long.class.getName().equals(rtype)) {
            return Meta.Type.Long;
        }
        if ("float".equals(rtype) || Float.class.getName().equals(rtype)) {
            return Meta.Type.Float;
        }
        if ("double".equals(rtype) || Double.class.getName().equals(rtype)) {
            return Meta.Type.Double;
        }
        return Meta.Type.String;
    }

    public void method(Clazz.MethodDef mdef) {
        this.method = mdef;
        this.methods.put(mdef, null);
    }

    public String getExtra() {
        return this.extra;
    }

    public long lastModified() {
        return 0L;
    }

    public InputStream openInputStream() throws IOException {
        final PipedInputStream pin = new PipedInputStream();
        final PipedOutputStream pout = new PipedOutputStream(pin);
        this.getExecutor().execute(new Runnable(){

            public void run() {
                try {
                    MetaTypeReader.this.write(pout);
                }
                catch (IOException e) {
                    IO.close(pin);
                }
                IO.close(pout);
            }
        });
        return pin;
    }

    private Executor getExecutor() {
        return this.reporter.getPlugin(Executor.class);
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void write(OutputStream out) throws IOException {
        try {
            this.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
        pw.println("<?xml version='1.0'?>");
        this.metadata.print(0, pw);
        pw.flush();
    }

    void finish() throws Exception {
        if (!this.finished) {
            this.finished = true;
            this.clazz.parseClassFileWithCollector(this);
            Meta.OCD ocd = null;
            ocd = this.ocdAnnotation != null ? this.ocdAnnotation.getAnnotation(Meta.OCD.class) : Configurable.createConfigurable(Meta.OCD.class, new HashMap());
            String id = this.clazz.getFQN();
            String name = Clazz.unCamel(Clazz.getShortName(this.clazz.getFQN()));
            String description = null;
            String localization = id;
            boolean factory = this.factory;
            if (ocd.id() != null) {
                id = ocd.id();
            }
            if (ocd.name() != null) {
                name = ocd.name();
            }
            if (ocd.localization() != null) {
                localization = ocd.localization();
            }
            if (ocd.description() != null) {
                description = ocd.description();
            }
            String pid = id;
            if (this.override) {
                pid = this.designatePid;
                factory = this.factory;
                id = this.designatePid;
            } else if (this.ocdAnnotation.get("factory") != null) {
                factory = true;
            }
            this.ocd.addAttribute("name", name);
            this.ocd.addAttribute("id", id);
            this.ocd.addAttribute("description", description);
            this.ocd.addAttribute("localization", localization);
            for (Map.Entry<Clazz.MethodDef, Meta.AD> entry : this.methods.entrySet()) {
                this.addMethod(entry.getKey(), entry.getValue());
            }
            this.designate.addAttribute("pid", pid);
            if (factory) {
                this.designate.addAttribute("factoryPid", pid);
            }
            this.object.addAttribute("ocdref", id);
        }
    }

    public void setDesignate(String pid, boolean factory) {
        this.override = true;
        this.factory = factory;
        this.designatePid = pid;
    }
}

