/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class TextRenderer
extends HtmlBasicInputRenderer {
    private static final Attribute[] INPUT_ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.INPUTTEXT);
    private static final Attribute[] OUTPUT_ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.OUTPUTTEXT);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
    }

    @Override
    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        boolean shouldWriteIdAttribute = false;
        boolean isOutput = false;
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        String dir = (String)component.getAttributes().get("dir");
        String lang = (String)component.getAttributes().get("lang");
        String title = (String)component.getAttributes().get("title");
        if (component instanceof UIInput) {
            writer.startElement("input", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            writer.writeAttribute("type", (Object)"text", null);
            writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
            if ("off".equals(component.getAttributes().get("autocomplete"))) {
                writer.writeAttribute("autocomplete", (Object)"off", "autocomplete");
            }
            if (currentValue != null) {
                writer.writeAttribute("value", (Object)currentValue, "value");
            }
            if (null != styleClass) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            RenderKitUtils.renderPassThruAttributes(context, writer, component, INPUT_ATTRIBUTES, TextRenderer.getNonOnChangeBehaviors(component));
            RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
            RenderKitUtils.renderOnchange(context, component, false);
            writer.endElement("input");
        } else {
            isOutput = component instanceof UIOutput;
            if (isOutput) {
                if (styleClass != null || style != null || dir != null || lang != null || title != null || (shouldWriteIdAttribute = this.shouldWriteIdAttribute(component))) {
                    writer.startElement("span", component);
                    this.writeIdAttributeIfNecessary(context, writer, component);
                    if (null != styleClass) {
                        writer.writeAttribute("class", (Object)styleClass, "styleClass");
                    }
                    RenderKitUtils.renderPassThruAttributes(context, writer, component, OUTPUT_ATTRIBUTES);
                }
                if (currentValue != null) {
                    Object val = component.getAttributes().get("escape");
                    if (val != null && Boolean.valueOf(val.toString()).booleanValue()) {
                        writer.writeText((Object)currentValue, component, "value");
                    } else {
                        writer.write(currentValue);
                    }
                }
            }
        }
        if (isOutput && (styleClass != null || style != null || dir != null || lang != null || title != null || shouldWriteIdAttribute)) {
            writer.endElement("span");
        }
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        boolean renderChildren = WebConfiguration.getInstance().isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AllowTextChildren);
        if (!renderChildren) {
            return;
        }
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncodeChildren(component)) {
            return;
        }
        if (component.getChildCount() > 0) {
            for (UIComponent kid : component.getChildren()) {
                this.encodeRecursive(context, kid);
            }
        }
    }
}

