/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.components;

import java.io.IOException;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class ScrollerComponent
extends UICommand {
    private static final String NORTH = "NORTH";
    private static final String SOUTH = "SOUTH";
    private static final String EAST = "EAST";
    private static final String WEST = "WEST";
    private static final byte ACTION_NEXT = -1;
    private static final byte ACTION_PREVIOUS = -2;
    private static final String FORM_NUMBER_ATTR = "com.sun.faces.FormNumber";
    private static final String FACET_MARKUP_ORIENTATION_ATTR = "navFacetOrientation";

    public ScrollerComponent() {
        this.setRendererType(null);
    }

    public void decode(FacesContext context) {
        String clientId = this.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String action = (String)requestParameterMap.get(clientId + "_action");
        if (action == null || action.length() == 0) {
            return;
        }
        MethodExpression me = context.getApplication().getExpressionFactory().createMethodExpression(context.getELContext(), action, null, new Class[0]);
        this.setActionExpression(me);
        String curPage = (String)requestParameterMap.get(clientId + "_curPage");
        int currentPage = Integer.valueOf(curPage);
        int actionInt = Integer.valueOf(action);
        switch (actionInt) {
            case -1: {
                ++currentPage;
                break;
            }
            case -2: {
                --currentPage;
                break;
            }
            default: {
                currentPage = actionInt;
            }
        }
        int currentRow = (currentPage - 1) * this.getRowsPerPage(context);
        this.getAttributes().put("currentPage", currentPage);
        this.getAttributes().put("currentRow", currentRow);
        this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
    }

    public void encodeEnd(FacesContext context) throws IOException {
        int currentPage = 1;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = this.getClientId(context);
        Integer curPage = (Integer)this.getAttributes().get("currentPage");
        if (curPage != null) {
            currentPage = curPage;
        }
        int totalPages = this.getTotalPages(context);
        writer.write("<table border=\"0\" cellpadding=\"0\" align=\"center\">");
        writer.write("<tr align=\"center\" valign=\"top\">");
        writer.write("<td><font size=\"-1\">Result&nbsp;Page:&nbsp;</font></td>");
        writer.write("<td>");
        this.writeNavWidgetMarkup(context, clientId, -2, 1 < currentPage);
        writer.write("</td>");
        int first = 1;
        int last = totalPages;
        if (10 < currentPage) {
            first = currentPage - 10;
        }
        if (currentPage + 9 < totalPages) {
            last = currentPage + 9;
        }
        for (int i = first; i <= last; ++i) {
            writer.write("<td>");
            this.writeNavWidgetMarkup(context, clientId, i, i != currentPage);
            writer.write("</td>");
        }
        writer.write("<td>");
        this.writeNavWidgetMarkup(context, clientId, -1, currentPage < totalPages);
        writer.write("</td>");
        writer.write("</tr>");
        writer.write(this.getHiddenFields(clientId));
        writer.write("</table>");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String getFamily() {
        return "Scroller";
    }

    protected void writeNavWidgetMarkup(FacesContext context, String clientId, int navActionType, boolean enabled) throws IOException {
        UIComponent facet;
        String linkText;
        String facetName;
        ResponseWriter writer = context.getResponseWriter();
        String facetOrientation = NORTH;
        boolean isPageNumber = false;
        switch (navActionType) {
            case -1: {
                facetName = "next";
                linkText = "Next";
                break;
            }
            case -2: {
                facetName = "previous";
                linkText = "Previous";
                break;
            }
            default: {
                facetName = "number";
                linkText = "" + navActionType;
                isPageNumber = true;
                if (enabled) break;
                facetName = "current";
            }
        }
        writer.write("\n&nbsp;");
        if (enabled) {
            writer.write("<a " + this.getAnchorAttrs(context, clientId, navActionType) + ">");
        }
        if ((facet = this.getFacet(facetName)) != null) {
            if (!(!isPageNumber || (facetOrientation = (String)this.getAttributes().get(FACET_MARKUP_ORIENTATION_ATTR)).equalsIgnoreCase(NORTH) || facetOrientation.equalsIgnoreCase(SOUTH) || facetOrientation.equalsIgnoreCase(EAST) || facetOrientation.equalsIgnoreCase(WEST))) {
                facetOrientation = NORTH;
            }
            if (facetOrientation.equalsIgnoreCase(NORTH) || facetOrientation.equalsIgnoreCase(EAST)) {
                facet.encodeBegin(context);
                if (facet.getRendersChildren()) {
                    facet.encodeChildren(context);
                }
                facet.encodeEnd(context);
            }
            if (facetOrientation.equalsIgnoreCase(NORTH)) {
                writer.startElement("br", null);
                writer.endElement("br");
            }
        }
        if (null != facet) {
            if (navActionType != -1 && navActionType != -2) {
                writer.write(linkText);
            }
        } else {
            writer.write(linkText);
        }
        if (null != facet) {
            if (facetOrientation.equalsIgnoreCase(SOUTH)) {
                writer.startElement("br", null);
                writer.endElement("br");
            }
            if (facetOrientation.equalsIgnoreCase(SOUTH) || facetOrientation.equalsIgnoreCase(WEST)) {
                facet.encodeBegin(context);
                if (facet.getRendersChildren()) {
                    facet.encodeChildren(context);
                }
                facet.encodeEnd(context);
            }
        }
        if (enabled) {
            writer.write("</a>");
        }
    }

    private String getAnchorAttrs(FacesContext context, String clientId, int action) {
        int currentPage = 1;
        int formNumber = this.getFormNumber(context);
        Integer curPage = (Integer)this.getAttributes().get("currentPage");
        if (curPage != null) {
            currentPage = curPage;
        }
        return "href=\"#\" onmousedown=\"document.forms[" + formNumber + "]['" + clientId + "_action'].value='" + action + "'; " + "document.forms[" + formNumber + "]['" + clientId + "_curPage'].value='" + currentPage + "'; " + "document.forms[" + formNumber + "].submit()\"";
    }

    private String getHiddenFields(String clientId) {
        return "<input type=\"hidden\" name=\"" + clientId + "_action\"/>\n" + "<input type=\"hidden\" name=\"" + clientId + "_curPage\"/>";
    }

    protected UIForm getForm(FacesContext context) {
        UIComponent parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }

    protected int getFormNumber(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Integer formsInt = (Integer)requestMap.get(FORM_NUMBER_ATTR);
        if (formsInt != null) {
            Integer n = formsInt;
            Integer n2 = formsInt = Integer.valueOf(formsInt - 1);
        } else {
            formsInt = 0;
        }
        return formsInt;
    }

    protected int getTotalPages(FacesContext context) {
        String forValue = (String)this.getAttributes().get("for");
        UIData uiData = (UIData)this.getForm(context).findComponent(forValue);
        if (uiData == null) {
            return 0;
        }
        int rowsPerPage = uiData.getRows();
        int totalRows = uiData.getRowCount();
        int result = totalRows / rowsPerPage;
        if (0 != totalRows % rowsPerPage) {
            ++result;
        }
        return result;
    }

    protected int getRowsPerPage(FacesContext context) {
        String forValue = (String)this.getAttributes().get("for");
        UIData uiData = (UIData)this.getForm(context).findComponent(forValue);
        if (uiData == null) {
            return 0;
        }
        return uiData.getRows();
    }
}

