/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.popup;

import com.sun.javaee.blueprints.components.ui.popup.PopupUtil;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class PopupRenderer
extends Renderer {
    private boolean bDebug = false;
    private static final String RENDERED_SCRIPT_KEY = "bpcatalog-ajax-script-popup";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIOutput outComp = (UIOutput)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderScriptOnce(writer, component, context);
        String id = (String)outComp.getAttributes().get("id");
        String xmlHttpRequestURL = (String)outComp.getAttributes().get("xmlHttpRequestURL");
        String elementNamePairs = (String)outComp.getAttributes().get("elementNamePairs");
        if (this.bDebug) {
            System.out.println("XXX Renderer Data - " + id + " - " + xmlHttpRequestURL + " - " + elementNamePairs);
        }
        URL sxURL = PopupRenderer.class.getResource("/META-INF/popup/PopupTemplateTop.txt");
        String sxTemplate = PopupUtil.readInFragmentAsString(sxURL);
        String sxScript = this.createParseMessageScript(elementNamePairs);
        if (this.bDebug) {
            System.out.println(" Parse Message Script " + sxScript);
        }
        HashMap<String, String> hmSub = new HashMap<String, String>();
        hmSub.put("%%%ID%%%", id);
        hmSub.put("%%%REQUESTURL%%%", xmlHttpRequestURL);
        hmSub.put("%%%PARSE_MESSAGE_CODE%%%", sxScript);
        writer.write(PopupUtil.parseString(sxTemplate, hmSub, false));
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIOutput outComp = (UIOutput)component;
        URL sxURL = PopupRenderer.class.getResource("/META-INF/popup/PopupTemplateBottom.txt");
        String sxResource = PopupUtil.readInFragmentAsString(sxURL);
        ResponseWriter writer = context.getResponseWriter();
        PopupUtil.readWriteCharUtil(sxURL, (Writer)writer);
    }

    private String createParseMessageScript(String fields) {
        StringBuffer sxBuff = new StringBuffer();
        String docKey = "";
        sxBuff.append("var resultx = req.responseXML.getElementsByTagName(\"response\")[0];\n");
        StringTokenizer st = new StringTokenizer(fields, ",");
        int iPos = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            docKey = token.substring((iPos = token.indexOf("=")) + 1);
            if (docKey.toLowerCase().indexOf("img") >= 0 || docKey.toLowerCase().indexOf("image") >= 0) {
                sxBuff.append("document.getElementById(\"" + docKey + "\").src=resultx.getElementsByTagName(\"" + token.substring(0, iPos) + "\")[0].childNodes[0].nodeValue;\n");
                continue;
            }
            sxBuff.append("document.getElementById(\"" + docKey + "\").firstChild.nodeValue=resultx.getElementsByTagName(\"" + token.substring(0, iPos) + "\")[0].childNodes[0].nodeValue;\n");
        }
        return sxBuff.toString();
    }

    private void renderScriptOnce(ResponseWriter writer, UIComponent component, FacesContext context) throws IOException {
        Map requestMap = context.getExternalContext().getRequestMap();
        Boolean scriptRendered = (Boolean)requestMap.get(RENDERED_SCRIPT_KEY);
        if (scriptRendered == Boolean.TRUE) {
            return;
        }
        requestMap.put(RENDERED_SCRIPT_KEY, Boolean.TRUE);
        writer.write("\n");
        writer.startElement("link", component);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeAttribute("href", (Object)"popup.css", null);
        writer.endElement("link");
        writer.write("\n");
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)"popup.js", null);
        writer.endElement("script");
        writer.write("\n");
    }
}

