/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.renderkit;

import com.sun.javaee.blueprints.components.ui.components.GraphComponent;
import com.sun.javaee.blueprints.components.ui.model.Graph;
import com.sun.javaee.blueprints.components.ui.model.Node;
import com.sun.javaee.blueprints.components.ui.renderkit.BaseRenderer;
import com.sun.javaee.blueprints.components.ui.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class MenuBarRenderer
extends BaseRenderer {
    public static final String URL_PREFIX = "/faces";
    public static final String FORM_NUMBER_ATTR = "com.sun.faces.FormNumber";
    private static Logger logger = Util.getLogger("com.sun.javaee.blueprints.components.ui.renderkit.MenuBarRenderer");
    protected String treeClass = null;
    protected String selectedClass = null;
    protected String unselectedClass = null;
    protected String clientId = null;
    protected UIComponent component = null;
    protected FacesContext context = null;

    public void decode(FacesContext context, UIComponent component) {
        Object graph = null;
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String path = (String)requestParameterMap.get(component.getClientId(context));
        if (path != null && path.length() != 0) {
            component.getAttributes().put("path", path);
            component.queueEvent((FacesEvent)new ActionEvent(component));
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("ActionEvent queued on Graph component for " + path);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Node menu;
        Graph graph = null;
        graph = (Graph)((GraphComponent)component).getValue();
        if (graph == null) {
            throw new FacesException("Graph could not be located");
        }
        Node root = graph.getRoot();
        if (root == null) {
            throw new FacesException("Graph has no root node");
        }
        if (root.getChildCount() < 1) {
            return;
        }
        this.component = component;
        this.context = context;
        this.clientId = component.getClientId(context);
        this.treeClass = (String)component.getAttributes().get("menuClass");
        this.selectedClass = (String)component.getAttributes().get("selectedClass");
        this.unselectedClass = (String)component.getAttributes().get("unselectedClass");
        Iterator menus = null;
        ResponseWriter writer = context.getResponseWriter();
        writer.write("<table border=\"0\" cellspacing=\"3\" cellpadding=\"0\"");
        if (this.treeClass != null) {
            writer.write(" class=\"");
            writer.write(this.treeClass);
            writer.write("\"");
        }
        writer.write(">");
        writer.write("\n");
        writer.write("<tr>");
        menus = root.getChildren();
        while (menus.hasNext()) {
            menu = (Node)menus.next();
            writer.write("<th bgcolor=\"silver\" align=\"left\">");
            if (menu.isEnabled()) {
                writer.write("<a href=\"");
                writer.write(this.getSubmitScript(menu.getPath(), context));
                writer.write(" >");
                writer.write(menu.getLabel());
                writer.write("</a>");
            } else {
                writer.write(menu.getLabel());
            }
            writer.write("</th>");
        }
        writer.write("</tr>");
        writer.write("<tr>");
        menus = root.getChildren();
        while (menus.hasNext()) {
            menu = (Node)menus.next();
            writer.write("<td bgcolor=\"silver\" align=\"left\" valign=\"top\">");
            if (menu.isExpanded()) {
                writer.write("<ul>");
                Iterator items = menu.getChildren();
                while (items.hasNext()) {
                    Node node = (Node)items.next();
                    writer.write("<li>");
                    if (node.getLabel() != null) {
                        writer.write("   ");
                        String labelStyle = null;
                        if (node.isSelected() && this.selectedClass != null) {
                            labelStyle = this.selectedClass;
                        } else if (!node.isSelected() && this.unselectedClass != null) {
                            labelStyle = this.unselectedClass;
                        }
                        if (node.isEnabled()) {
                            writer.write("<a href=\"");
                            writer.write(this.href(node.getAction()));
                            writer.write("\"");
                            if (labelStyle != null) {
                                writer.write(" class=\"");
                                writer.write(labelStyle);
                                writer.write("\"");
                            }
                            writer.write(">");
                        } else if (labelStyle != null) {
                            writer.write("<span class=\"");
                            writer.write(labelStyle);
                            writer.write("\">");
                        }
                        writer.write(node.getLabel());
                        if (node.getLabel() != null) {
                            writer.write("</a>");
                        } else if (labelStyle != null) {
                            writer.write("</span>");
                        }
                    }
                    writer.write("</li>");
                }
                writer.write("</ul>");
            } else {
                writer.write("&nbsp;");
            }
            writer.write("</td>");
        }
        writer.write("<input type=\"hidden\" name=\"" + this.clientId + "\" />");
        writer.write("</table>");
    }

    protected String getSubmitScript(String path, FacesContext context) {
        UIForm uiform = this.getMyForm();
        String formClientId = uiform.getClientId(context);
        StringBuffer sb = new StringBuffer();
        sb.append("#\" onclick=\"document.forms['" + formClientId + "']['" + this.clientId + "'].value='" + path + "';document.forms['" + formClientId + "'].submit()\"");
        return sb.toString();
    }

    protected UIForm getMyForm() {
        UIComponent parent;
        for (parent = this.component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }

    protected String href(String action) {
        if (action != null && !action.startsWith("/")) {
            return action;
        }
        StringBuffer sb = new StringBuffer();
        if (action.startsWith("/")) {
            sb.append(this.context.getExternalContext().getRequestContextPath());
        }
        sb.append(action);
        return sb.toString();
    }
}

