/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.textfield;

import com.sun.faces.util.Util;
import com.sun.javaee.blueprints.components.ui.textfield.CompletionResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AjaxPhaseListener
implements PhaseListener {
    static final int MAX_RESULTS_RETURNED = 10;
    private static final String AJAX_VIEW_ID = "ajax-autocomplete";
    public static final String SCRIPT_VIEW_ID = "ajax-textfield.js";
    public static final String CSS_VIEW_ID = "ajax-textfield.css";

    public void afterPhase(PhaseEvent event) {
        String rootId = event.getFacesContext().getViewRoot().getViewId();
        if (rootId.endsWith(SCRIPT_VIEW_ID)) {
            this.handleResourceRequest(event, "/META-INF/textfield/script.js", "text/javascript");
        } else if (rootId.endsWith(CSS_VIEW_ID)) {
            this.handleResourceRequest(event, "/META-INF/textfield/styles.css", "text/css");
        } else if (rootId.indexOf(AJAX_VIEW_ID) != -1) {
            this.handleAjaxRequest(event);
        }
    }

    private void handleAjaxRequest(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        Object object = context.getExternalContext().getRequest();
        if (!(object instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)object;
        String prefix = request.getParameter("prefix");
        String method = request.getParameter("method");
        StringBuffer sb = new StringBuffer();
        boolean namesAdded = false;
        try {
            CompletionResult results = this.getCompletionItems(context, method, prefix);
            List items = results.getItems();
            int n = Math.min(10, items.size());
            if (n > 0) {
                sb.append("<items>");
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    sb.append("<item>");
                    sb.append(it.next().toString());
                    sb.append("</item>");
                }
                sb.append("</items>");
                response.setContentType("text/xml");
                response.setHeader("Cache-Control", "no-cache");
                response.getWriter().write(sb.toString());
            } else {
                response.setStatus(204);
            }
            event.getFacesContext().responseComplete();
            return;
        }
        catch (EvaluationException ee) {
            ee.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private CompletionResult getCompletionItems(FacesContext context, String methodExpr, String prefix) {
        if (UIComponentTag.isValueReference((String)methodExpr)) {
            Class[] argTypes = new Class[]{FacesContext.class, String.class, CompletionResult.class};
            MethodBinding vb = context.getApplication().createMethodBinding(methodExpr, argTypes);
            CompletionResult result = new CompletionResult();
            Object[] args = new Object[]{context, prefix, result};
            vb.invoke(context, args);
            return result;
        }
        Object[] params = new Object[]{methodExpr};
        throw new FacesException(Util.getExceptionMessageString((String)"com.sun.faces.INVALID_EXPRESSION", (Object[])params));
    }

    private void handleResourceRequest(PhaseEvent event, String resource, String contentType) {
        URL url = AjaxPhaseListener.class.getResource(resource);
        URLConnection conn = null;
        InputStream stream = null;
        BufferedReader bufReader = null;
        HttpServletResponse response = (HttpServletResponse)event.getFacesContext().getExternalContext().getResponse();
        OutputStreamWriter outWriter = null;
        String curLine = null;
        try {
            outWriter = new OutputStreamWriter((OutputStream)response.getOutputStream(), response.getCharacterEncoding());
            conn = url.openConnection();
            conn.setUseCaches(false);
            stream = conn.getInputStream();
            bufReader = new BufferedReader(new InputStreamReader(stream));
            response.setContentType(contentType);
            response.setStatus(200);
            while (null != (curLine = bufReader.readLine())) {
                outWriter.write(curLine + "\n");
            }
            outWriter.flush();
            outWriter.close();
            event.getFacesContext().responseComplete();
        }
        catch (Exception e) {
            String message = "Can't load resource:" + url.toExternalForm();
            System.err.println(message);
            e.printStackTrace();
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
}

