/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.event.PhaseEvent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;

public final class ViewHandler
extends TagHandlerImpl {
    private static final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private static final Class[] LISTENER_SIG = new Class[]{PhaseEvent.class};
    private final TagAttribute locale = this.getAttribute("locale");
    private final TagAttribute renderKitId = this.getAttribute("renderKitId");
    private final TagAttribute contentType = this.getAttribute("contentType");
    private final TagAttribute encoding = this.getAttribute("encoding");
    private final TagAttribute beforePhase;
    private final TagAttribute afterPhase;
    private final TagAttribute transientFlag;

    public ViewHandler(TagConfig config) {
        super(config);
        TagAttribute testForNull = this.getAttribute("beforePhase");
        this.beforePhase = null == testForNull ? this.getAttribute("beforePhaseListener") : testForNull;
        testForNull = this.getAttribute("afterPhase");
        this.afterPhase = null == testForNull ? this.getAttribute("afterPhaseListener") : testForNull;
        this.transientFlag = this.getAttribute("transient");
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
        Object partialStateSavingVal = null;
        if (root != null) {
            Boolean b;
            MethodExpression m;
            String v;
            block13: {
                if (this.locale != null) {
                    try {
                        root.setLocale(ComponentSupport.getLocale(ctx, this.locale));
                    }
                    catch (TagAttributeException tae) {
                        Object result = this.locale.getObject(ctx);
                        if (null != result) break block13;
                        Locale l = Locale.getDefault();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, "Using {0} for locale because expression {1} returned null.", new Object[]{l, this.locale.toString()});
                        }
                        root.setLocale(l);
                    }
                }
            }
            if (this.renderKitId != null) {
                v = this.renderKitId.getValue(ctx);
                root.setRenderKitId(v);
            }
            if (this.contentType != null) {
                v = this.contentType.getValue(ctx);
                ctx.getFacesContext().getAttributes().put("facelets.ContentType", v);
            }
            if (this.encoding != null) {
                v = this.encoding.getValue(ctx);
                ctx.getFacesContext().getAttributes().put("facelets.Encoding", v);
            }
            if (this.beforePhase != null) {
                m = this.beforePhase.getMethodExpression(ctx, null, LISTENER_SIG);
                root.setBeforePhaseListener(m);
            }
            if (this.afterPhase != null) {
                m = this.afterPhase.getMethodExpression(ctx, null, LISTENER_SIG);
                root.setAfterPhaseListener(m);
            }
            if (this.transientFlag != null && (b = Boolean.valueOf(this.transientFlag.getValue(ctx))) != null) {
                root.setTransient(b);
            }
            String viewId = root.getViewId();
            assert (null != viewId);
            assert (0 < viewId.length());
        }
        this.nextHandler.apply(ctx, parent);
    }
}

