/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.RIConstants;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

public class MenuRenderer
extends HtmlBasicInputRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.SELECTMANYMENU);

    public Object convertSelectManyValue(FacesContext context, UISelectMany uiSelectMany, String[] newValues) throws ConverterException {
        ValueExpression valueExpression = uiSelectMany.getValueExpression("value");
        Object result = newValues;
        boolean throwException = false;
        if (null != valueExpression) {
            Object value;
            Class modelType = valueExpression.getType(context.getELContext());
            if (modelType != null) {
                result = this.convertSelectManyValuesForModel(context, uiSelectMany, modelType, newValues);
            }
            if (result == null && (value = valueExpression.getValue(context.getELContext())) != null) {
                result = this.convertSelectManyValuesForModel(context, uiSelectMany, value.getClass(), newValues);
            }
            if (result == null) {
                throwException = true;
            }
        } else {
            result = this.convertSelectManyValues(context, uiSelectMany, Object[].class, newValues);
        }
        if (throwException) {
            StringBuffer values = new StringBuffer();
            if (null != newValues) {
                for (int i = 0; i < newValues.length; ++i) {
                    if (i == 0) {
                        values.append(newValues[i]);
                        continue;
                    }
                    values.append(' ').append(newValues[i]);
                }
            }
            Object[] params = new Object[]{values.toString(), valueExpression.getExpressionString()};
            throw new ConverterException(MessageUtils.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", params));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SelectMany Component  " + uiSelectMany.getId() + " convertedValues " + result);
        }
        return result;
    }

    public Object convertSelectOneValue(FacesContext context, UISelectOne uiSelectOne, String newValue) throws ConverterException {
        if (RIConstants.NO_VALUE.equals(newValue)) {
            return null;
        }
        if (newValue == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No conversion necessary for SelectOne Component  " + uiSelectOne.getId() + " since the new value is null ");
            }
            return null;
        }
        Object convertedValue = super.getConvertedValue(context, uiSelectOne, newValue);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SelectOne Component  " + uiSelectOne.getId() + " convertedValue " + convertedValue);
        }
        return convertedValue;
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldDecode(component)) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        assert (clientId != null);
        if (component instanceof UISelectMany) {
            Map<String, String[]> requestParameterValuesMap = context.getExternalContext().getRequestParameterValuesMap();
            if (requestParameterValuesMap.containsKey(clientId)) {
                Object[] newValues = requestParameterValuesMap.get(clientId);
                this.setSubmittedValue(component, newValues);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("submitted values for UISelectMany component " + component.getId() + " after decoding " + Arrays.toString(newValues));
                }
            } else {
                this.setSubmittedValue(component, new String[0]);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Set empty array for UISelectMany component " + component.getId() + " after decoding ");
                }
            }
        } else {
            Map<String, String> requestParameterMap = context.getExternalContext().getRequestParameterMap();
            if (requestParameterMap.containsKey(clientId)) {
                String newValue = requestParameterMap.get(clientId);
                this.setSubmittedValue(component, newValue);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("submitted value for UISelectOne component " + component.getId() + " after decoding " + newValue);
                }
            } else {
                this.setSubmittedValue(component, RIConstants.NO_VALUE);
            }
        }
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        this.renderSelect(context, component);
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (component instanceof UISelectMany) {
            RequestStateManager.set(context, "com.sun.faces.ComponentForValue", component);
            return this.convertSelectManyValue(context, (UISelectMany)component, (String[])submittedValue);
        }
        return this.convertSelectOneValue(context, (UISelectOne)component, (String)submittedValue);
    }

    protected Object convertSelectManyValuesForModel(FacesContext context, UISelectMany uiSelectMany, Class modelType, String[] newValues) {
        if (modelType.isArray()) {
            return this.convertSelectManyValues(context, uiSelectMany, modelType, newValues);
        }
        if (Collection.class.isAssignableFrom(modelType)) {
            Object[] values = (Object[])this.convertSelectManyValues(context, uiSelectMany, Object[].class, newValues);
            Collection targetCollection = null;
            Object collectionTypeHint = uiSelectMany.getAttributes().get("collectionType");
            if (collectionTypeHint != null) {
                targetCollection = this.createCollectionFromHint(collectionTypeHint);
            } else {
                Collection currentValue = (Collection)uiSelectMany.getValue();
                if (currentValue != null) {
                    targetCollection = this.cloneValue(currentValue);
                }
                if (targetCollection == null) {
                    targetCollection = this.createCollection(currentValue, modelType);
                }
                if (targetCollection == null) {
                    targetCollection = this.bestGuess(modelType, values.length);
                }
            }
            for (Object v : values) {
                targetCollection.add(v);
            }
            return targetCollection;
        }
        if (Object.class.equals((Object)modelType)) {
            return this.convertSelectManyValues(context, uiSelectMany, Object[].class, newValues);
        }
        throw new FacesException("Target model Type is no a Collection or Array");
    }

    protected Object convertSelectManyValues(FacesContext context, UISelectMany uiSelectMany, Class arrayClass, String[] newValues) throws ConverterException {
        Object result;
        int len = null != newValues ? newValues.length : 0;
        Class<?> elementType = arrayClass.getComponentType();
        if (elementType.equals(String.class)) {
            return newValues;
        }
        try {
            result = Array.newInstance(elementType, len);
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
        if (null == newValues) {
            return result;
        }
        Converter converter = uiSelectMany.getConverter();
        if (null == converter && null == (converter = Util.getConverterForClass(elementType, context))) {
            if (elementType.equals(Object.class)) {
                return newValues;
            }
            StringBuffer valueStr = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    valueStr.append(newValues[i]);
                    continue;
                }
                valueStr.append(' ').append(newValues[i]);
            }
            Object[] params = new Object[]{valueStr.toString(), "null Converter"};
            throw new ConverterException(MessageUtils.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", params));
        }
        assert (null != result);
        if (elementType.isPrimitive()) {
            for (int i = 0; i < len; ++i) {
                if (elementType.equals(Boolean.TYPE)) {
                    Array.setBoolean(result, i, (Boolean)converter.getAsObject(context, uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Byte.TYPE)) {
                    Array.setByte(result, i, (Byte)converter.getAsObject(context, uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Double.TYPE)) {
                    Array.setDouble(result, i, (Double)converter.getAsObject(context, uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Float.TYPE)) {
                    Array.setFloat(result, i, ((Float)converter.getAsObject(context, uiSelectMany, newValues[i])).floatValue());
                    continue;
                }
                if (elementType.equals(Integer.TYPE)) {
                    Array.setInt(result, i, (Integer)converter.getAsObject(context, uiSelectMany, newValues[i]));
                    continue;
                }
                if (elementType.equals(Character.TYPE)) {
                    Array.setChar(result, i, ((Character)converter.getAsObject(context, uiSelectMany, newValues[i])).charValue());
                    continue;
                }
                if (elementType.equals(Short.TYPE)) {
                    Array.setShort(result, i, (Short)converter.getAsObject(context, uiSelectMany, newValues[i]));
                    continue;
                }
                if (!elementType.equals(Long.TYPE)) continue;
                Array.setLong(result, i, (Long)converter.getAsObject(context, uiSelectMany, newValues[i]));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    Object converted = converter.getAsObject(context, uiSelectMany, newValues[i]);
                    logger.fine("String value: " + newValues[i] + " converts to : " + converted);
                }
                Array.set(result, i, converter.getAsObject(context, uiSelectMany, newValues[i]));
            }
        }
        return result;
    }

    protected boolean renderOption(FacesContext context, UIComponent component, Converter converter, SelectItem curItem, Object currentSelections, Object[] submittedValues, HtmlBasicRenderer.OptionComponentInfo optionInfo) throws IOException {
        String labelClass;
        Object itemValue;
        Object[] valuesArray;
        String valueString = this.getFormattedValue(context, component, curItem.getValue(), converter);
        if (submittedValues != null) {
            boolean containsValue = this.containsaValue(submittedValues);
            if (containsValue) {
                valuesArray = submittedValues;
                itemValue = valueString;
            } else {
                valuesArray = currentSelections;
                itemValue = curItem.getValue();
            }
        } else {
            valuesArray = currentSelections;
            itemValue = curItem.getValue();
        }
        boolean isSelected = this.isSelected(context, component, itemValue, valuesArray, converter);
        if (optionInfo.isHideNoSelection() && curItem.isNoSelectionOption() && currentSelections != null && !isSelected) {
            return false;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.writeText("\t", component, null);
        writer.startElement("option", component);
        writer.writeAttribute("value", valueString, "value");
        if (isSelected) {
            writer.writeAttribute("selected", true, "selected");
        }
        if (!optionInfo.isDisabled() && curItem.isDisabled()) {
            writer.writeAttribute("disabled", true, "disabled");
        }
        if ((labelClass = optionInfo.isDisabled() || curItem.isDisabled() ? optionInfo.getDisabledClass() : optionInfo.getEnabledClass()) != null) {
            writer.writeAttribute("class", labelClass, "labelClass");
        }
        if (curItem.isEscape()) {
            String label = curItem.getLabel();
            if (label == null) {
                label = valueString;
            }
            writer.writeText(label, component, "label");
        } else {
            writer.write(curItem.getLabel());
        }
        writer.endElement("option");
        writer.writeText("\n", component, null);
        return true;
    }

    protected void writeDefaultSize(ResponseWriter writer, int itemCount) throws IOException {
        writer.writeAttribute("size", "1", "size");
    }

    protected boolean containsaValue(Object valueArray) {
        if (null != valueArray) {
            int len = Array.getLength(valueArray);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(valueArray, i);
                if (value == null || value.equals(RIConstants.NO_VALUE)) continue;
                return true;
            }
        }
        return false;
    }

    protected Object getCurrentSelectedValues(UIComponent component) {
        if (component instanceof UISelectMany) {
            UISelectMany select = (UISelectMany)component;
            Object value = select.getValue();
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                return ((Collection)value).toArray();
            }
            if (value.getClass().isArray()) {
                if (Array.getLength(value) == 0) {
                    return null;
                }
            } else if (!value.getClass().isArray()) {
                logger.warning("The UISelectMany value should be an array or a collection type, the actual type is " + value.getClass().getName());
            }
            return value;
        }
        UISelectOne select = (UISelectOne)component;
        Object val = select.getValue();
        if (val != null) {
            return new Object[]{val};
        }
        return null;
    }

    protected String getMultipleText(UIComponent component) {
        if (component instanceof UISelectMany) {
            return " multiple ";
        }
        return "";
    }

    protected Object[] getSubmittedSelectedValues(UIComponent component) {
        if (component instanceof UISelectMany) {
            UISelectMany select = (UISelectMany)component;
            return (Object[])select.getSubmittedValue();
        }
        UISelectOne select = (UISelectOne)component;
        Object val = select.getSubmittedValue();
        if (val != null) {
            return new Object[]{val};
        }
        return null;
    }

    protected boolean isSelected(FacesContext context, UIComponent component, Object itemValue, Object valueArray, Converter converter) {
        if (itemValue == null && valueArray == null) {
            return true;
        }
        if (null != valueArray) {
            if (!valueArray.getClass().isArray()) {
                logger.warning("valueArray is not an array, the actual type is " + valueArray.getClass());
                return valueArray.equals(itemValue);
            }
            int len = Array.getLength(valueArray);
            for (int i = 0; i < len; ++i) {
                Object compareValue;
                Object value = Array.get(valueArray, i);
                if (value == null && itemValue == null) {
                    return true;
                }
                if (value == null ^ itemValue == null) continue;
                if (converter == null) {
                    compareValue = this.coerceToModelType(context, itemValue, value.getClass());
                } else {
                    compareValue = itemValue;
                    if (compareValue instanceof String && !(value instanceof String)) {
                        compareValue = converter.getAsObject(context, component, (String)compareValue);
                    }
                }
                if (!value.equals(compareValue)) continue;
                return true;
            }
        }
        return false;
    }

    protected int renderOptions(FacesContext context, UIComponent component, Iterator<SelectItem> items) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)((Object)component)).getConverter();
        }
        int count = 0;
        Object currentSelections = this.getCurrentSelectedValues(component);
        Object[] submittedValues = this.getSubmittedSelectedValues(component);
        Map<String, Object> attributes = component.getAttributes();
        boolean componentDisabled = Util.componentIsDisabled(component);
        HtmlBasicRenderer.OptionComponentInfo optionInfo = new HtmlBasicRenderer.OptionComponentInfo((String)attributes.get("disabledClass"), (String)attributes.get("enabledClass"), componentDisabled, this.isHideNoSelection(component));
        RequestStateManager.set(context, "com.sun.faces.ComponentForValue", component);
        while (items.hasNext()) {
            SelectItem item = items.next();
            if (item instanceof SelectItemGroup) {
                writer.startElement("optgroup", component);
                writer.writeAttribute("label", item.getLabel(), "label");
                if (!componentDisabled && item.isDisabled()) {
                    writer.writeAttribute("disabled", true, "disabled");
                }
                ++count;
                SelectItem[] itemsArray = ((SelectItemGroup)item).getSelectItems();
                for (int i = 0; i < itemsArray.length; ++i) {
                    if (!this.renderOption(context, component, converter, itemsArray[i], currentSelections, submittedValues, optionInfo)) continue;
                    ++count;
                }
                writer.endElement("optgroup");
                continue;
            }
            if (!this.renderOption(context, component, converter, item, currentSelections, submittedValues, optionInfo)) continue;
            ++count;
        }
        return count;
    }

    protected void renderSelect(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Rendering 'select'");
        }
        writer.startElement("select", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        writer.writeAttribute("name", component.getClientId(context), "clientId");
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }
        if (!this.getMultipleText(component).equals("")) {
            writer.writeAttribute("multiple", true, "multiple");
        }
        Iterator<SelectItem> items = RenderKitUtils.getSelectItems(context, component);
        FastStringWriter bufferedWriter = new FastStringWriter(128);
        context.setResponseWriter(writer.cloneWithWriter(bufferedWriter));
        int count = this.renderOptions(context, component, items);
        context.setResponseWriter(writer);
        Integer size = (Integer)component.getAttributes().get("size");
        if (size == null || size == Integer.MIN_VALUE) {
            size = count;
        }
        this.writeDefaultSize(writer, size);
        RenderKitUtils.renderPassThruAttributes(context, writer, component, ATTRIBUTES, MenuRenderer.getNonOnChangeBehaviors(component));
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        RenderKitUtils.renderOnchange(context, component, false);
        writer.write(bufferedWriter.toString());
        writer.endElement("select");
    }

    protected Object coerceToModelType(FacesContext ctx, Object value, Class itemValueType) {
        Object newValue;
        try {
            ExpressionFactory ef = ctx.getApplication().getExpressionFactory();
            newValue = ef.coerceToType(value, itemValueType);
        }
        catch (ELException ele) {
            newValue = value;
        }
        catch (IllegalArgumentException iae) {
            newValue = value;
        }
        return newValue;
    }

    protected Collection createCollection(Collection collection, Class<? extends Collection> fallBackType) {
        block3: {
            Class<Collection<Object>> lookupClass;
            Class<Collection<Object>> clazz = lookupClass = collection != null ? collection.getClass() : fallBackType;
            if (!lookupClass.isInterface() && !Modifier.isAbstract(lookupClass.getModifiers())) {
                try {
                    return lookupClass.newInstance();
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block3;
                    logger.log(Level.SEVERE, "Unable to create new Collection instance for type " + lookupClass.getName(), e);
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Collection cloneValue(Object value) {
        if (!(value instanceof Cloneable)) return null;
        Method clone = ReflectionUtils.lookupMethod(value.getClass(), "clone", new Class[0]);
        if (clone != null) {
            try {
                Collection c = (Collection)clone.invoke(value, new Object[0]);
                c.clear();
                return c;
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) return null;
                logger.log(Level.SEVERE, "Unable to clone collection type: {0}", value.getClass().getName());
                logger.log(Level.SEVERE, e.toString(), e);
                return null;
            }
        } else {
            if (!logger.isLoggable(Level.FINE)) return null;
            logger.log(Level.FINE, "Type {0} implements Cloneable, but has no public clone method.", value.getClass().getName());
        }
        return null;
    }

    protected Collection bestGuess(Class<? extends Collection> type, int initialSize) {
        if (SortedSet.class.isAssignableFrom(type)) {
            return new TreeSet();
        }
        if (Queue.class.isAssignableFrom(type)) {
            return new LinkedList();
        }
        if (Set.class.isAssignableFrom(type)) {
            return new HashSet(initialSize);
        }
        return new ArrayList(initialSize);
    }

    protected Collection createCollectionFromHint(Object collectionTypeHint) {
        Class collectionType;
        if (collectionTypeHint instanceof Class) {
            collectionType = (Class)collectionTypeHint;
        } else if (collectionTypeHint instanceof String) {
            try {
                collectionType = Util.loadClass((String)collectionTypeHint, this);
            }
            catch (ClassNotFoundException cnfe) {
                throw new FacesException(cnfe);
            }
        } else {
            throw new FacesException("'collectionType' should resolve to type String or Class.  Found: " + collectionTypeHint.getClass().getName());
        }
        Collection c = this.createCollection(null, collectionType);
        if (c == null) {
            throw new FacesException("Unable to create collection type " + collectionType);
        }
        return c;
    }

    protected boolean isHideNoSelection(UIComponent component) {
        Object result = component.getAttributes().get("hideNoSelectionOption");
        return result != null ? (Boolean)result : false;
    }
}

