/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.util;

import com.sun.faces.util.FacesLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;

public final class Resource {
    protected static final Logger log = FacesLogger.FACELETS_FACTORY.getLogger();

    public static URL getResourceUrl(FacesContext ctx, String path) throws MalformedURLException {
        ExternalContext externalContext = ctx.getExternalContext();
        URL url = externalContext.getResource(path);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Resource-Url from external context: " + url);
        }
        if (url == null && Resource.resourceExist(externalContext, path)) {
            url = Resource.getUrlForResourceAsStream(externalContext, path);
        }
        return url;
    }

    private static boolean resourceExist(ExternalContext externalContext, String path) {
        ServletContext servletContext;
        InputStream stream;
        if ("/".equals(path)) {
            return true;
        }
        Object ctx = externalContext.getContext();
        if (ctx instanceof ServletContext && (stream = (servletContext = (ServletContext)ctx).getResourceAsStream(path)) != null) {
            block4: {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (!log.isLoggable(Level.FINEST)) break block4;
                    log.log(Level.FINEST, "Closing stream", e);
                }
            }
            return true;
        }
        return false;
    }

    private static URL getUrlForResourceAsStream(final ExternalContext externalContext, String path) throws MalformedURLException {
        URLStreamHandler handler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                final String file = u.getFile();
                return new URLConnection(u){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        Object ctx;
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Opening internal url to " + file);
                        }
                        if ((ctx = externalContext.getContext()) instanceof ServletContext) {
                            ServletContext servletContext = (ServletContext)ctx;
                            InputStream stream = servletContext.getResourceAsStream(file);
                            if (stream == null) {
                                throw new FileNotFoundException("Cannot open resource " + file);
                            }
                            return stream;
                        }
                        throw new IOException("Cannot open resource for an context of " + (ctx != null ? ctx.getClass() : null));
                    }
                };
            }
        };
        return new URL("internal", null, 0, path, handler);
    }
}

