/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mojarra.cdi;

import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CdiLifecycleFactory
extends LifecycleFactory {
    public CdiLifecycleFactory(LifecycleFactory wrapped) {
        super(wrapped);
    }

    public void addLifecycle(String lifecycleId, Lifecycle lifecycle) {
    }

    public Lifecycle getLifecycle(String lifecycleId) {
        Lifecycle result = null;
        if (lifecycleId.equals("DEFAULT")) {
            result = this.getWrapped().getLifecycle(lifecycleId);
        } else {
            BeanManager beanManager = this.getBeanManager();
            AnnotatedType type = beanManager.createAnnotatedType(Lifecycle.class);
            Set beans = beanManager.getBeans(type.getBaseType(), new Annotation[]{NamedLiteral.of((String)lifecycleId)});
            for (Bean bean : beans) {
                Named named = bean.getBeanClass().getAnnotation(Named.class);
                if (!named.value().equals(lifecycleId)) continue;
                result = (Lifecycle)CDI.current().select(new Annotation[]{named}).get();
                break;
            }
        }
        return result;
    }

    private BeanManager getBeanManager() {
        InitialContext initialContext2;
        BeanManager beanManager = null;
        try {
            initialContext2 = new InitialContext();
            beanManager = (BeanManager)initialContext2.lookup("java:comp/BeanManager");
        }
        catch (NamingException initialContext2) {
            // empty catch block
        }
        if (beanManager == null) {
            try {
                initialContext2 = new InitialContext();
                beanManager = (BeanManager)initialContext2.lookup("java:comp/env/BeanManager");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return beanManager;
    }

    public Iterator<String> getLifecycleIds() {
        ArrayList<String> lifecycleIds = new ArrayList<String>();
        this.getWrapped().getLifecycleIds().forEachRemaining(lifecycleIds::add);
        BeanManager beanManager = this.getBeanManager();
        AnnotatedType type = beanManager.createAnnotatedType(Lifecycle.class);
        Set beans = beanManager.getBeans(type.getBaseType(), new Annotation[0]);
        for (Bean bean : beans) {
            if (!bean.getBeanClass().isAnnotationPresent(Named.class)) continue;
            Named named = bean.getBeanClass().getAnnotation(Named.class);
            lifecycleIds.add(named.value());
        }
        return lifecycleIds.iterator();
    }
}

