/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class RegexValidator
implements Validator,
StateHolder {
    private ValueExpression regex;
    public static final String VALIDATOR_ID = "javax.faces.RegularExpression";
    public static final String NOT_STRING_MESSAGE_ID = "javax.faces.validator.RegexValidator.NOT_STRING";
    public static final String PATTERN_NOT_SET_MESSAGE_ID = "javax.faces.validator.RegexValidator.PATTERN_NOT_SET";
    public static final String NOT_MATCHED_MESSAGE_ID = "javax.faces.validator.RegexValidator.NOT_MATCHED";
    public static final String MATCH_EXCEPTION_MESSAGE_ID = "javax.faces.validator.RegexValidator.MATCH_EXCEPTION";
    private boolean transientValue = false;

    public void setPattern(ValueExpression pattern) {
        this.regex = pattern;
    }

    public ValueExpression getPattern() {
        return this.regex;
    }

    public void validate(FacesContext context, UIComponent component, Object value) {
        Locale locale = context.getViewRoot().getLocale();
        ELContext elcontext = context.getELContext();
        if (!this.regex.getType(elcontext).equals(String.class)) {
            FacesMessage fmsg = MessageFactory.getMessage(locale, NOT_STRING_MESSAGE_ID, new Object[]{null});
            throw new ValidatorException(fmsg);
        }
        String regexStr = (String)this.regex.getValue(elcontext);
        if (null == regexStr) {
            FacesMessage fmsg = MessageFactory.getMessage(locale, PATTERN_NOT_SET_MESSAGE_ID, new Object[]{null});
            throw new ValidatorException(fmsg);
        }
        if (!(value instanceof String)) {
            FacesMessage fmsg = MessageFactory.getMessage(locale, NOT_STRING_MESSAGE_ID, new Object[]{null});
            throw new ValidatorException(fmsg);
        }
        if (regexStr.equals("")) {
            FacesMessage fmsg = MessageFactory.getMessage(locale, PATTERN_NOT_SET_MESSAGE_ID, new Object[]{null});
            throw new ValidatorException(fmsg);
        }
        try {
            Pattern pattern = Pattern.compile(regexStr);
            Matcher matcher = pattern.matcher((String)value);
            if (!matcher.matches()) {
                Object[] params = new Object[]{regexStr};
                FacesMessage fmsg = MessageFactory.getMessage(locale, NOT_MATCHED_MESSAGE_ID, params);
                throw new ValidatorException(fmsg);
            }
        }
        catch (PatternSyntaxException pse) {
            FacesMessage fmsg = MessageFactory.getMessage(locale, MATCH_EXCEPTION_MESSAGE_ID, new Object[]{null});
            throw new ValidatorException(fmsg, (Throwable)pse);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{null != this.regex ? this.regex.getExpressionString() : null, this.regex.getType(context.getELContext())};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        if (null != values[0] && null != values[1]) {
            this.regex = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), (String)values[0], (Class)values[1]);
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }
}

