/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceImpl;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ResourceManager;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

public class ResourceHandlerImpl
extends ResourceHandler {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    ResourceManager manager = new ResourceManager();
    List<Pattern> excludePatterns;
    private long creationTime = System.currentTimeMillis();
    private WebConfiguration webconfig = WebConfiguration.getInstance();

    public ResourceHandlerImpl() {
        this.initExclusions();
    }

    public Resource createResource(String resourceName) {
        Util.notNull("resourceName", resourceName);
        return this.createResource(resourceName, null, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        Util.notNull("resourceName", resourceName);
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Util.notNull("resourceName", resourceName);
        String ctype = contentType != null ? contentType : this.getContentType(resourceName);
        ResourceInfo info = this.manager.findResource(libraryName, resourceName, ctype, FacesContext.getCurrentInstance());
        return info != null ? new ResourceImpl(this, info, ctype) : null;
    }

    public boolean libraryExists(String libraryName) {
        FacesContext context = FacesContext.getCurrentInstance();
        LibraryInfo info = this.manager.findLibrary(libraryName, null, context);
        return info != null;
    }

    public boolean isResourceRequest(FacesContext context) {
        Boolean isResourceRequest = (Boolean)RequestStateManager.get(context, "com.sun.faces.RESOURCE_REQUEST");
        if (isResourceRequest == null) {
            String resourceId = this.normalizeResourceRequest(context);
            isResourceRequest = resourceId != null ? resourceId.startsWith("/javax.faces.resource") : Boolean.FALSE.booleanValue();
            RequestStateManager.set(context, "com.sun.faces.RESOURCE_REQUEST", isResourceRequest);
        }
        return isResourceRequest;
    }

    public String getRendererTypeForResourceName(String resourceName) {
        String rendererType = null;
        String contentType = this.getContentType(resourceName);
        if (null != contentType) {
            if (-1 != (contentType = contentType.toLowerCase()).indexOf("javascript")) {
                rendererType = "javax.faces.resource.Script";
            } else if (-1 != contentType.indexOf("css")) {
                rendererType = "javax.faces.resource.Stylesheet";
            }
        }
        return rendererType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRequest(FacesContext context) throws IOException {
        String resourceId = this.normalizeResourceRequest(context);
        if (resourceId == null) {
            return;
        }
        ExternalContext extContext = context.getExternalContext();
        HttpServletResponse response = (HttpServletResponse)extContext.getResponse();
        if (this.isExcluded(resourceId)) {
            response.setStatus(404);
            return;
        }
        assert (null != resourceId);
        assert (resourceId.startsWith("/javax.faces.resource"));
        Resource resource = null;
        String resourceName = null;
        String libraryName = null;
        if ("/javax.faces.resource".length() < resourceId.length()) {
            resourceName = resourceId.substring("/javax.faces.resource".length() + 1);
            assert (resourceName != null);
            libraryName = (String)context.getExternalContext().getRequestParameterMap().get("ln");
            resource = this.createResource(resourceName, libraryName);
        }
        if (resource != null) {
            if (resource.userAgentNeedsUpdate(context)) {
                Channel resourceChannel = null;
                Channel out = null;
                ByteBuffer buf = this.allocateByteBuffer();
                try {
                    InputStream in = resource.getInputStream();
                    if (in == null) {
                        this.send404(context, response, resourceName, libraryName);
                        return;
                    }
                    resourceChannel = Channels.newChannel(resource.getInputStream());
                    out = Channels.newChannel((OutputStream)response.getOutputStream());
                    response.setBufferSize(buf.capacity());
                    String contentType = resource.getContentType();
                    if (contentType != null) {
                        response.setContentType(resource.getContentType());
                    }
                    this.handleHeaders(resource, response);
                    int size = 0;
                    int thisRead = resourceChannel.read(buf);
                    int totalWritten = 0;
                    while (thisRead != -1) {
                        buf.rewind();
                        buf.limit(thisRead);
                        while ((totalWritten += out.write(buf)) < size) {
                        }
                        buf.clear();
                        size += thisRead;
                        thisRead = resourceChannel.read(buf);
                    }
                    response.setContentLength(size);
                }
                catch (IOException ioe) {
                    this.send404(context, response, resourceName, libraryName, ioe);
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    if (resourceChannel != null) {
                        resourceChannel.close();
                    }
                }
            } else {
                response.setStatus(304);
            }
        } else {
            this.send404(context, response, resourceName, libraryName);
        }
    }

    private void send404(FacesContext ctx, HttpServletResponse response, String resourceName, String libraryName) {
        this.send404(ctx, response, resourceName, libraryName, null);
    }

    private void send404(FacesContext ctx, HttpServletResponse response, String resourceName, String libraryName, Throwable t) {
        Level level;
        response.setStatus(404);
        if (ctx.getApplication().getProjectStage() != ProjectStage.Production) {
            level = Level.WARNING;
        } else {
            Level level2 = level = t != null ? Level.WARNING : Level.FINE;
        }
        if (libraryName != null) {
            if (LOGGER.isLoggable(level)) {
                LOGGER.log(level, "jsf.application.resource.unable_to_serve_from_library", new Object[]{resourceName, libraryName});
                if (t != null) {
                    LOGGER.log(level, "", t);
                }
            }
        } else if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, "jsf.application.resource.unable_to_serve", new Object[]{resourceName});
            if (t != null) {
                LOGGER.log(level, "", t);
            }
        }
    }

    long getCreationTime() {
        return this.creationTime;
    }

    void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    WebConfiguration getWebConfig() {
        return this.webconfig;
    }

    private String getContentType(String resourceName) {
        return FacesContext.getCurrentInstance().getExternalContext().getMimeType(resourceName);
    }

    private String normalizeResourceRequest(FacesContext context) {
        String path;
        String facesServletMapping = Util.getFacesMapping(context);
        if (!Util.isPrefixMapped(facesServletMapping)) {
            path = context.getExternalContext().getRequestServletPath();
            int i = path.lastIndexOf(".");
            if (0 < i) {
                path = path.substring(0, i);
            }
        } else {
            path = context.getExternalContext().getRequestPathInfo();
        }
        return path;
    }

    private boolean isExcluded(String resourceId) {
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(resourceId).matches()) continue;
            return true;
        }
        return false;
    }

    private void initExclusions() {
        String excludesParam = this.webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResourceExcludes);
        String[] patterns = Util.split(excludesParam, " ");
        this.excludePatterns = new ArrayList<Pattern>(patterns.length);
        for (String pattern : patterns) {
            this.excludePatterns.add(Pattern.compile(".*\\" + pattern));
        }
    }

    private void handleHeaders(Resource resource, HttpServletResponse response) {
        for (Map.Entry cur : resource.getResponseHeaders().entrySet()) {
            response.setHeader((String)cur.getKey(), (String)cur.getValue());
        }
    }

    private ByteBuffer allocateByteBuffer() {
        int size;
        try {
            size = Integer.parseInt(this.webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResourceBufferSize));
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.resource.invalid_resource_buffer_size", new Object[]{this.webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResourceBufferSize), WebConfiguration.WebContextInitParameter.ResourceBufferSize.getQualifiedName(), WebConfiguration.WebContextInitParameter.ResourceBufferSize.getDefaultValue()});
            }
            size = Integer.parseInt(WebConfiguration.WebContextInitParameter.ResourceBufferSize.getDefaultValue());
        }
        return ByteBuffer.allocate(size);
    }
}

