/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.ViewHandlingStrategyManager;
import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

public class MultiViewHandler
extends ViewHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    protected ViewHandlingStrategyManager viewHandlingStrategy = new ViewHandlingStrategyManager();
    private String[] configuredExtensions;

    public MultiViewHandler() {
        WebConfiguration config = WebConfiguration.getInstance();
        String defaultSuffixConfig = config.getOptionValue(WebConfiguration.WebContextInitParameter.DefaultSuffix);
        this.configuredExtensions = Util.split(defaultSuffixConfig, " ");
    }

    public void initView(FacesContext context) throws FacesException {
        if (context.getExternalContext().getRequestCharacterEncoding() == null) {
            super.initView(context);
        }
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        Util.notNull("context", context);
        Util.notNull("viewToRender", viewToRender);
        if (!viewToRender.isRendered()) {
            return;
        }
        this.viewHandlingStrategy.getStrategy(viewToRender.getViewId()).renderView(context, this, viewToRender);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        return this.viewHandlingStrategy.getStrategy(viewId).restoreView(context, this, viewId);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        return this.viewHandlingStrategy.getStrategy(viewId).createView(context, this, viewId);
    }

    public Locale calculateLocale(FacesContext context) {
        Locale perf;
        Util.notNull("context", context);
        Locale result = null;
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext() && (result = this.findMatch(context, perf = (Locale)locales.next())) == null) {
        }
        if (result == null) {
            result = context.getApplication().getDefaultLocale() == null ? Locale.getDefault() : context.getApplication().getDefaultLocale();
        }
        return result;
    }

    public String calculateRenderKitId(FacesContext context) {
        Util.notNull("context", context);
        Map requestParamMap = context.getExternalContext().getRequestParameterMap();
        String result = (String)requestParamMap.get("javax.faces.RenderKitId");
        if (result == null && null == (result = context.getApplication().getDefaultRenderKitId())) {
            result = "HTML_BASIC";
        }
        return result;
    }

    public void writeState(FacesContext context) throws IOException {
        Util.notNull("context", context);
        if (!context.getPartialViewContext().isAjaxRequest()) {
            WriteBehindStateWriter writer;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Begin writing marker for viewId " + context.getViewRoot().getViewId());
            }
            if ((writer = WriteBehindStateWriter.getCurrentInstance()) != null) {
                writer.writingState();
            }
            context.getResponseWriter().write("~com.sun.faces.saveStateFieldMarker~");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End writing marker for viewId " + context.getViewRoot().getViewId());
            }
        }
    }

    public String getActionURL(FacesContext context, String viewId) {
        Util.notNull("context", context);
        Util.notNull("viewId", viewId);
        if (viewId.charAt(0) != '/') {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", viewId);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.illegal_view_id_error", viewId);
            }
            throw new IllegalArgumentException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        String contextPath = extContext.getRequestContextPath();
        String mapping = Util.getFacesMapping(context);
        if (mapping == null) {
            return contextPath + viewId;
        }
        if (Util.isPrefixMapped(mapping)) {
            if (mapping.equals("/*")) {
                return contextPath + viewId;
            }
            return contextPath + mapping + viewId;
        }
        int period = viewId.lastIndexOf(46);
        if (period < 0) {
            return contextPath + viewId + mapping;
        }
        if (!viewId.endsWith(mapping)) {
            return contextPath + viewId.substring(0, period) + mapping;
        }
        return contextPath + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        ExternalContext extContext = context.getExternalContext();
        if (path.charAt(0) == '/') {
            return extContext.getRequestContextPath() + path;
        }
        return path;
    }

    public UIViewRoot createViewPrivate(FacesContext ctx, String viewId) {
        Util.notNull("context", ctx);
        UIViewRoot result = (UIViewRoot)ctx.getApplication().createComponent("javax.faces.ViewRoot");
        if (viewId != null) {
            String mapping = Util.getFacesMapping(ctx);
            if (mapping != null) {
                if (!Util.isPrefixMapped(mapping)) {
                    viewId = this.convertViewId(ctx, viewId);
                } else if ((viewId = this.normalizeRequestURI(viewId, mapping)).equals(mapping)) {
                    this.send404Error(ctx);
                }
            }
            result.setViewId(viewId);
        }
        Locale locale = null;
        String renderKitId = null;
        if (ctx.getViewRoot() != null) {
            locale = ctx.getViewRoot().getLocale();
            renderKitId = ctx.getViewRoot().getRenderKitId();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created new view for " + viewId);
        }
        if (locale == null) {
            locale = ctx.getApplication().getViewHandler().calculateLocale(ctx);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Locale for this view as determined by calculateLocale " + locale.toString());
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using locale from previous view " + locale.toString());
        }
        if (renderKitId == null) {
            renderKitId = ctx.getApplication().getViewHandler().calculateRenderKitId(ctx);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("RenderKitId for this view as determined by calculateRenderKitId " + renderKitId);
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using renderKitId from previous view " + renderKitId);
        }
        result.setLocale(locale);
        result.setRenderKitId(renderKitId);
        return result;
    }

    public UIViewRoot restoreViewPrivate(FacesContext ctx, String viewId) {
        ExternalContext extContext = ctx.getExternalContext();
        String mapping = Util.getFacesMapping(ctx);
        UIViewRoot viewRoot = null;
        if (mapping != null) {
            viewId = !Util.isPrefixMapped(mapping) ? this.convertViewId(ctx, viewId) : this.normalizeRequestURI(viewId, mapping);
        }
        if (extContext.getRequestPathInfo() == null && mapping != null && Util.isPrefixMapped(mapping)) {
            try {
                ctx.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Response Complete for" + viewId);
                }
                extContext.redirect(extContext.getRequestContextPath());
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        } else {
            ViewHandler outerViewHandler = ctx.getApplication().getViewHandler();
            String renderKitId = outerViewHandler.calculateRenderKitId(ctx);
            viewRoot = Util.getStateManager(ctx).restoreView(ctx, viewId, renderKitId);
        }
        return viewRoot;
    }

    protected Locale findMatch(FacesContext context, Locale pref) {
        Locale defaultLocale;
        Locale result = null;
        Iterator it = context.getApplication().getSupportedLocales();
        while (it.hasNext()) {
            Locale supportedLocale = (Locale)it.next();
            if (pref.equals(supportedLocale)) {
                result = supportedLocale;
                break;
            }
            if (!pref.getLanguage().equals(supportedLocale.getLanguage()) || supportedLocale.getCountry().length() != 0) continue;
            result = supportedLocale;
        }
        if (null == result && (defaultLocale = context.getApplication().getDefaultLocale()) != null) {
            if (pref.equals(defaultLocale)) {
                result = defaultLocale;
            } else if (pref.getLanguage().equals(defaultLocale.getLanguage()) && defaultLocale.getCountry().length() == 0) {
                result = defaultLocale;
            }
        }
        return result;
    }

    protected String normalizeRequestURI(String uri, String mapping) {
        if (mapping == null || !Util.isPrefixMapped(mapping)) {
            return uri;
        }
        int length = mapping.length() + 1;
        StringBuilder builder = new StringBuilder(length);
        builder.append(mapping).append('/');
        String mappingMod = builder.toString();
        boolean logged = false;
        while (uri.startsWith(mappingMod)) {
            if (!logged && logger.isLoggable(Level.WARNING)) {
                logged = true;
                logger.log(Level.WARNING, "jsf.viewhandler.requestpath.recursion", new Object[]{uri, mapping});
            }
            uri = uri.substring(length - 1);
        }
        return uri;
    }

    protected void send404Error(FacesContext context) {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            context.responseComplete();
            response.sendError(404);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    protected String convertViewId(FacesContext context, String viewId) {
        StringBuilder buffer = new StringBuilder(viewId);
        for (String ext : this.configuredExtensions) {
            if (viewId.endsWith(ext)) {
                return viewId;
            }
            int extIdx = viewId.lastIndexOf(46);
            if (extIdx != -1) {
                buffer.replace(extIdx, viewId.length(), ext);
            } else {
                buffer.append(ext);
            }
            String convertedViewId = buffer.toString();
            try {
                if (context.getExternalContext().getResource(convertedViewId) != null) {
                    return convertedViewId;
                }
                buffer.setLength(0);
                buffer.append(viewId);
            }
            catch (MalformedURLException e) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.send404Error(context);
        return null;
    }
}

