/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.FaceletHandler;
import com.sun.faces.facelets.tag.CompositeFaceletHandler;
import com.sun.faces.facelets.tag.Tag;
import com.sun.faces.facelets.tag.TagAttribute;
import com.sun.faces.facelets.tag.TagConfig;
import com.sun.faces.facelets.tag.TagException;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class TagHandler
implements FaceletHandler {
    protected final String tagId;
    protected final Tag tag;
    protected final FaceletHandler nextHandler;

    public TagHandler(TagConfig config) {
        this.tagId = config.getTagId();
        this.tag = config.getTag();
        this.nextHandler = config.getNextHandler();
    }

    protected final TagAttribute getAttribute(String localName) {
        return this.tag.getAttributes().get(localName);
    }

    protected final TagAttribute getRequiredAttribute(String localName) throws TagException {
        TagAttribute attr = this.getAttribute(localName);
        if (attr == null) {
            throw new TagException(this.tag, "Attribute '" + localName + "' is required");
        }
        return attr;
    }

    protected final Iterator findNextByType(Class type) {
        ArrayList<FaceletHandler> found = new ArrayList<FaceletHandler>();
        if (type.isAssignableFrom(this.nextHandler.getClass())) {
            found.add(this.nextHandler);
        } else if (this.nextHandler instanceof CompositeFaceletHandler) {
            FaceletHandler[] h = ((CompositeFaceletHandler)this.nextHandler).getHandlers();
            for (int i = 0; i < h.length; ++i) {
                if (!type.isAssignableFrom(h[i].getClass())) continue;
                found.add(h[i]);
            }
        }
        return found.iterator();
    }

    public String toString() {
        return this.tag.toString();
    }
}

