/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.FaceletContext;
import com.sun.faces.facelets.FaceletException;
import com.sun.faces.facelets.el.LegacyValueBinding;
import com.sun.faces.facelets.tag.TagAttribute;
import com.sun.faces.facelets.tag.TagConfig;
import com.sun.faces.facelets.tag.TagException;
import com.sun.faces.facelets.tag.TagHandler;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.ActionSource2;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class SetPropertyActionListenerHandler
extends TagHandler {
    private final TagAttribute value = this.getRequiredAttribute("value");
    private final TagAttribute target = this.getRequiredAttribute("target");

    public SetPropertyActionListenerHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent instanceof ActionSource) {
            ActionSource src = (ActionSource)parent;
            if (ComponentSupport.isNew(parent)) {
                ValueExpression valueExpr = this.value.getValueExpression(ctx, Object.class);
                ValueExpression targetExpr = this.target.getValueExpression(ctx, Object.class);
                ActionListener listener = src instanceof ActionSource2 ? new SetPropertyListener(valueExpr, targetExpr) : new LegacySetPropertyListener(new LegacyValueBinding(valueExpr), new LegacyValueBinding(targetExpr));
                src.addActionListener(listener);
            }
        } else {
            throw new TagException(this.tag, "Parent is not of type ActionSource, type is: " + parent);
        }
    }

    private static class SetPropertyListener
    implements ActionListener,
    Serializable {
        private ValueExpression value;
        private ValueExpression target;

        public SetPropertyListener() {
        }

        public SetPropertyListener(ValueExpression value, ValueExpression target) {
            this.value = value;
            this.target = target;
        }

        public void processAction(ActionEvent evt) throws AbortProcessingException {
            FacesContext faces = FacesContext.getCurrentInstance();
            ELContext el = faces.getELContext();
            Object valueObj = this.value.getValue(el);
            if (valueObj != null) {
                ExpressionFactory factory = faces.getApplication().getExpressionFactory();
                valueObj = factory.coerceToType((Object)this.value, this.target.getType(el));
            }
            this.target.setValue(el, valueObj);
        }
    }

    private static class LegacySetPropertyListener
    implements ActionListener,
    Serializable {
        private ValueBinding value;
        private ValueBinding target;

        public LegacySetPropertyListener() {
        }

        public LegacySetPropertyListener(ValueBinding value, ValueBinding target) {
            this.value = value;
            this.target = target;
        }

        public void processAction(ActionEvent evt) throws AbortProcessingException {
            FacesContext faces = FacesContext.getCurrentInstance();
            Object valueObj = this.value.getValue(faces);
            this.target.setValue(faces, valueObj);
        }
    }
}

