/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mojarra.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.mojarra.rest.RestMappingMatch;
import org.eclipse.mojarra.rest.RestMappingMatcher;
import org.eclipse.mojarra.rest.RestPath;

@ApplicationScoped
public class DefaultRestMappingMatcher
implements RestMappingMatcher {
    private RestMappingMatch determineRestMappingMatch(FacesContext facesContext, Bean<?> bean) {
        RestMappingMatch result = null;
        Class clazz = bean.getBeanClass();
        AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(clazz);
        Set annotatedMethodSet = annotatedType.getMethods();
        for (AnnotatedMethod method : annotatedMethodSet) {
            String pathInfo;
            RestPath restPath;
            String path;
            if (!method.isAnnotationPresent(RestPath.class) || !Pattern.matches(path = (restPath = (RestPath)method.getAnnotation(RestPath.class)).value(), pathInfo = facesContext.getExternalContext().getRequestPathInfo())) continue;
            result = new RestMappingMatch();
            result.setBean(bean);
            result.setMethod(method.getJavaMember());
            result.setPathInfo(pathInfo);
            result.setRestPath(path);
        }
        return result;
    }

    private Iterator<Bean<?>> getBeans() {
        Set beans = CDI.current().getBeanManager().getBeans(Object.class, new Annotation[]{Any.Literal.INSTANCE});
        return beans.iterator();
    }

    @Override
    public RestMappingMatch match(FacesContext facesContext) {
        RestMappingMatch match = null;
        Iterator<Bean<?>> beans = this.getBeans();
        while (beans.hasNext()) {
            Bean<?> bean = beans.next();
            RestMappingMatch candidate = this.determineRestMappingMatch(facesContext, bean);
            if (match == null) {
                match = candidate;
                continue;
            }
            if (candidate == null || candidate.getLength() <= match.getLength()) continue;
            match = candidate;
        }
        return match;
    }
}

