/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mojarra.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.mojarra.rest.RestResponseMatcher;
import org.eclipse.mojarra.rest.RestResponseWriter;
import org.eclipse.mojarra.rest.RestResponseWriterContentType;

@ApplicationScoped
public class DefaultRestResponseMatcher
implements RestResponseMatcher {
    @Inject
    private BeanManager beanManager;

    @Override
    public RestResponseWriter getResponseWriter(String responseContentType) {
        RestResponseWriter result = null;
        AnnotatedType type = this.beanManager.createAnnotatedType(RestResponseWriter.class);
        Set beans = this.beanManager.getBeans(type.getBaseType(), new Annotation[0]);
        for (Bean bean : beans) {
            RestResponseWriterContentType contentType = bean.getBeanClass().getAnnotation(RestResponseWriterContentType.class);
            if (contentType == null || !contentType.value().equals(responseContentType)) continue;
            result = (RestResponseWriter)CDI.current().select(bean.getBeanClass(), new Annotation[0]).get();
            break;
        }
        if (result == null) {
            Bean bean;
            beans = this.beanManager.getBeans(type.getBaseType(), new Annotation[]{new Default.Literal()});
            Iterator iterator = beans.iterator();
            bean = (Bean)iterator.next();
            result = (RestResponseWriter)CDI.current().select(bean.getBeanClass(), new Annotation[0]).get();
        }
        return result;
    }
}

