/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.jk.common;

import com.sun.grizzly.http.jk.common.JniHandler;
import com.sun.grizzly.http.jk.core.JkChannel;
import com.sun.grizzly.http.jk.core.Msg;
import com.sun.grizzly.http.jk.core.MsgContext;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.LoggerUtils;
import java.io.IOException;
import java.util.logging.Level;

public class ChannelJni
extends JniHandler
implements JkChannel {
    int receivedNote = 1;

    public void init() throws IOException {
        super.initNative("channel.jni:jni");
        if (this.apr == null) {
            return;
        }
        this.apr.addJkHandler("channelJni", this);
        LoggerUtils.getLogger().info("JK: listening on channel.jni:jni");
        if (this.next == null) {
            if (this.nextName != null) {
                this.setNext(this.wEnv.getHandler(this.nextName));
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("dispatch");
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("request");
            }
            if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
                LoggerUtils.getLogger().log(Level.FINEST, "Setting default next " + this.next.getClass().getName());
            }
        }
    }

    public int receive(Msg msg, MsgContext ep) throws IOException {
        Msg sentResponse = (Msg)ep.getNote(this.receivedNote);
        ep.setNote(this.receivedNote, null);
        if (sentResponse == null) {
            if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
                LoggerUtils.getLogger().log(Level.FINEST, "No send() prior to receive(), no data buffer");
            }
            msg.reset();
            msg.end();
            sentResponse = msg;
        }
        sentResponse.processHeader();
        if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
            sentResponse.dump("received response ");
        }
        if (msg != sentResponse) {
            LoggerUtils.getLogger().severe("Error, in JNI mode the msg used for receive() must be identical with the one used for send()");
        }
        return 0;
    }

    public int send(Msg msg, MsgContext ep) throws IOException {
        ep.setNote(this.receivedNote, null);
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "ChannelJni.send: " + msg);
        }
        int rc = super.nativeDispatch(msg, ep, 21, 0);
        ep.setNote(this.receivedNote, msg);
        return rc;
    }

    public int flush(Msg msg, MsgContext ep) throws IOException {
        ep.setNote(this.receivedNote, null);
        return 0;
    }

    public boolean isSameAddress(MsgContext ep) {
        return true;
    }

    public void registerRequest(Request req, MsgContext ep, int count) {
    }

    public String getChannelName() {
        return this.getName();
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        if (this.apr == null) {
            return -1;
        }
        long xEnv = ep.getJniEnv();
        long cEndpointP = ep.getJniContext();
        int type = ep.getType();
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "ChannelJni.invoke: " + ep + " " + type);
        }
        switch (type) {
            case 10: {
                return this.receive(msg, ep);
            }
            case 11: {
                return this.send(msg, ep);
            }
            case 12: {
                return this.flush(msg, ep);
            }
        }
        ep.setNote(this.receivedNote, null);
        try {
            if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
                LoggerUtils.getLogger().log(Level.FINEST, "Received request " + xEnv);
            }
            msg.processHeader();
            if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
                msg.dump("Incoming msg ");
            }
            int status = this.next.invoke(msg, ep);
            if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
                LoggerUtils.getLogger().log(Level.FINEST, "after processCallbacks " + status);
            }
            return status;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }
}

