/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.jk.common;

import com.sun.grizzly.http.jk.core.JkHandler;
import com.sun.grizzly.http.jk.core.Msg;
import com.sun.grizzly.http.jk.core.MsgContext;
import com.sun.grizzly.util.LoggerUtils;
import java.io.IOException;
import java.util.logging.Level;

public class HandlerDispatch
extends JkHandler {
    JkHandler[] handlers = new JkHandler[32];
    String[] handlerNames = new String[32];
    static final int MAX_HANDLERS = 32;
    static final int RESERVED = 16;
    int currentId = 16;

    public void init() {
    }

    public int registerMessageType(int id, String name, JkHandler h, String[] sig) {
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "Register message " + id + " " + h.getName() + " " + h.getClass().getName());
        }
        if (id < 0) {
            for (int i = 0; i < this.handlerNames.length; ++i) {
                if (this.handlerNames[i] == null || !name.equals(this.handlerNames[i])) continue;
                return i;
            }
            this.handlers[this.currentId] = h;
            this.handlerNames[this.currentId] = name;
            ++this.currentId;
            return this.currentId;
        }
        this.handlers[id] = h;
        this.handlerNames[this.currentId] = name;
        return id;
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        byte type = msg.peekByte();
        ep.setType(type);
        if (type > this.handlers.length || this.handlers[type] == null) {
            if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
                LoggerUtils.getLogger().log(Level.FINEST, "Invalid handler " + type);
            }
            return 2;
        }
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "Received " + type + " " + this.handlers[type].getName());
        }
        JkHandler handler = this.handlers[type];
        return handler.invoke(msg, ep);
    }
}

