/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.jk.common;

import com.sun.grizzly.http.jk.apr.AprImpl;
import com.sun.grizzly.http.jk.common.MsgAjp;
import com.sun.grizzly.http.jk.core.JkChannel;
import com.sun.grizzly.http.jk.core.JkHandler;
import com.sun.grizzly.http.jk.core.Msg;
import com.sun.grizzly.http.jk.core.MsgContext;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.C2BConverter;
import com.sun.grizzly.util.buf.MessageBytes;
import java.io.IOException;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.apache.commons.modeler.Registry;

public class JniHandler
extends JkHandler {
    protected AprImpl apr;
    protected long nativeJkHandlerP;
    protected String jkHome;
    public static final int JK_HANDLE_JNI_DISPATCH = 21;
    public static final int JK_HANDLE_SHM_DISPATCH = 22;
    public static final int MSG_NOTE = 0;
    public static final int MB_NOTE = 2;
    private boolean paused = false;

    public void setJkHome(String s) {
        this.jkHome = s;
    }

    public String getJkHome() {
        return this.jkHome;
    }

    public void init() throws IOException {
    }

    protected void initNative(String nativeComponentName) {
        this.apr = (AprImpl)this.wEnv.getHandler("apr");
        if (this.apr == null) {
            try {
                this.apr = new AprImpl();
                this.wEnv.addHandler("apr", this.apr);
                this.apr.init();
                if (this.oname != null) {
                    ObjectName aprname = new ObjectName(this.oname.getDomain() + ":type=JkHandler, name=apr");
                    Registry.getRegistry(null, null).registerComponent((Object)this.apr, aprname, null);
                }
            }
            catch (Throwable t) {
                LoggerUtils.getLogger().log(Level.FINEST, "Can't load apr", t);
                this.apr = null;
            }
        }
        if (this.apr == null || !this.apr.isLoaded()) {
            if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
                LoggerUtils.getLogger().log(Level.FINEST, "No apr, disabling jni proxy ");
            }
            this.apr = null;
            return;
        }
        try {
            long xEnv = this.apr.getJkEnv();
            this.nativeJkHandlerP = this.apr.getJkHandler(xEnv, nativeComponentName);
            if (this.nativeJkHandlerP == 0L) {
                LoggerUtils.getLogger().log(Level.FINEST, "Component not found, creating it " + nativeComponentName);
                this.nativeJkHandlerP = this.apr.createJkHandler(xEnv, nativeComponentName);
            }
            LoggerUtils.getLogger().log(Level.FINEST, "Native proxy " + this.nativeJkHandlerP);
            this.apr.releaseJkEnv(xEnv);
        }
        catch (Throwable t) {
            this.apr = null;
        }
    }

    public void appendString(Msg msg, String s, C2BConverter charsetDecoder) throws IOException {
        ByteChunk bc = charsetDecoder.getByteChunk();
        charsetDecoder.recycle();
        charsetDecoder.convert(s);
        charsetDecoder.flushBuffer();
        msg.appendByteChunk(bc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws Exception {
        JniHandler jniHandler = this;
        synchronized (jniHandler) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws Exception {
        JniHandler jniHandler = this;
        synchronized (jniHandler) {
            this.paused = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsgContext createMsgContext() {
        if (this.nativeJkHandlerP == 0L || this.apr == null) {
            return null;
        }
        JniHandler jniHandler = this;
        synchronized (jniHandler) {
            try {
                while (this.paused) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        try {
            MsgContext msgCtx = new MsgContext();
            MsgAjp msg = new MsgAjp();
            msgCtx.setSource((JkChannel)((Object)this));
            msgCtx.setWorkerEnv(this.wEnv);
            msgCtx.setNext(this);
            msgCtx.setMsg(0, msg);
            C2BConverter c2b = new C2BConverter("iso-8859-1");
            msgCtx.setConverter(c2b);
            MessageBytes tmpMB = MessageBytes.newInstance();
            msgCtx.setNote(2, tmpMB);
            return msgCtx;
        }
        catch (Exception ex) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Can't create endpoint", ex);
            return null;
        }
    }

    public void setNativeAttribute(String name, String val) throws IOException {
        if (this.apr == null) {
            return;
        }
        if (this.nativeJkHandlerP == 0L) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Unitialized component " + name + " " + val);
            return;
        }
        long xEnv = this.apr.getJkEnv();
        this.apr.jkSetAttribute(xEnv, this.nativeJkHandlerP, name, val);
        this.apr.releaseJkEnv(xEnv);
    }

    public void initJkComponent() throws IOException {
        if (this.apr == null) {
            return;
        }
        if (this.nativeJkHandlerP == 0L) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Unitialized component ");
            return;
        }
        long xEnv = this.apr.getJkEnv();
        this.apr.jkInit(xEnv, this.nativeJkHandlerP);
        this.apr.releaseJkEnv(xEnv);
    }

    public void destroyJkComponent() throws IOException {
        if (this.apr == null) {
            return;
        }
        if (this.nativeJkHandlerP == 0L) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Unitialized component ");
            return;
        }
        long xEnv = this.apr.getJkEnv();
        this.apr.jkDestroy(xEnv, this.nativeJkHandlerP);
        this.apr.releaseJkEnv(xEnv);
    }

    protected void setNativeEndpoint(MsgContext msgCtx) {
        long xEnv = this.apr.getJkEnv();
        msgCtx.setJniEnv(xEnv);
        long epP = this.apr.createJkHandler(xEnv, "endpoint");
        LoggerUtils.getLogger().log(Level.FINEST, "create ep " + epP);
        if (epP == 0L) {
            return;
        }
        this.apr.jkInit(xEnv, epP);
        msgCtx.setJniContext(epP);
    }

    protected void recycleNative(MsgContext ep) {
        this.apr.jkRecycle(ep.getJniEnv(), ep.getJniContext());
    }

    protected int nativeDispatch(Msg msg, MsgContext ep, int code, int raw) throws IOException {
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "Sending packet " + code + " " + raw);
        }
        if (raw == 0) {
            msg.end();
        }
        long xEnv = ep.getJniEnv();
        long nativeContext = ep.getJniContext();
        if (nativeContext == 0L || xEnv == 0L) {
            this.setNativeEndpoint(ep);
            xEnv = ep.getJniEnv();
            nativeContext = ep.getJniContext();
        }
        if (xEnv == 0L || nativeContext == 0L || this.nativeJkHandlerP == 0L) {
            LoggerUtils.getLogger().log(Level.SEVERE, "invokeNative: Null pointer ");
            return -1;
        }
        int status = AprImpl.jkInvoke(xEnv, this.nativeJkHandlerP, nativeContext, code, msg.getBuffer(), 0, msg.getLen(), raw);
        if (status != 0 && status != 2) {
            LoggerUtils.getLogger().log(Level.SEVERE, "nativeDispatch: error " + status, new Throwable());
        }
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "Sending packet - done " + status);
        }
        return status;
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        long xEnv = ep.getJniEnv();
        int type = ep.getType();
        int status = this.nativeDispatch(msg, ep, type, 0);
        this.apr.jkRecycle(xEnv, ep.getJniContext());
        this.apr.releaseJkEnv(xEnv);
        return status;
    }
}

