/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.jk.common;

import com.sun.grizzly.http.jk.common.AprAcceptor;
import com.sun.grizzly.http.jk.common.AprConnection;
import com.sun.grizzly.http.jk.common.JniHandler;
import com.sun.grizzly.http.jk.common.MsgAjp;
import com.sun.grizzly.http.jk.core.JkChannel;
import com.sun.grizzly.http.jk.core.Msg;
import com.sun.grizzly.http.jk.core.MsgContext;
import com.sun.grizzly.http.jk.util.threads.ThreadPool;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.RequestGroupInfo;
import com.sun.grizzly.tcp.RequestInfo;
import com.sun.grizzly.util.LoggerUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.apache.commons.modeler.Registry;

public class ChannelUn
extends JniHandler
implements JkChannel {
    static final int CH_OPEN = 4;
    static final int CH_CLOSE = 5;
    static final int CH_READ = 6;
    static final int CH_WRITE = 7;
    String file;
    ThreadPool tp = ThreadPool.createThreadPool(true);
    int socketNote = 1;
    int isNote = 2;
    int osNote = 3;
    int localId = 0;
    ObjectName tpOName;
    ObjectName rgOName;
    RequestGroupInfo global = new RequestGroupInfo();
    int count = 0;
    int JMXRequestNote;
    boolean running = true;

    public ThreadPool getThreadPool() {
        return this.tp;
    }

    public void setFile(String f) {
        this.file = f;
    }

    public String getFile() {
        return this.file;
    }

    public void init() throws IOException {
        File socketFile;
        if (this.file == null) {
            LoggerUtils.getLogger().log(Level.FINEST, "No file, disabling unix channel");
            return;
        }
        if (this.wEnv != null && this.wEnv.getLocalId() != 0) {
            this.localId = this.wEnv.getLocalId();
        }
        if (this.localId != 0) {
            this.file = this.file + this.localId;
        }
        if (!(socketFile = new File(this.file)).isAbsolute()) {
            String home = this.wEnv.getJkHome();
            if (home == null) {
                LoggerUtils.getLogger().log(Level.FINEST, "No jkhome");
            } else {
                File homef = new File(home);
                socketFile = new File(homef, this.file);
                LoggerUtils.getLogger().log(Level.FINEST, "Making the file absolute " + socketFile);
            }
        }
        if (!socketFile.exists()) {
            try {
                FileOutputStream fos = new FileOutputStream(socketFile);
                fos.write(1);
                fos.close();
            }
            catch (Throwable t) {
                LoggerUtils.getLogger().log(Level.SEVERE, "Attempting to create the file failed, disabling channel" + socketFile);
                return;
            }
        }
        if (!socketFile.delete()) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Can't remove socket file " + socketFile);
            return;
        }
        super.initNative("channel.un:" + this.file);
        if (this.apr == null || !this.apr.isLoaded()) {
            LoggerUtils.getLogger().log(Level.FINEST, "Apr is not available, disabling unix channel ");
            this.apr = null;
            return;
        }
        this.setNativeAttribute("file", this.file);
        this.setNativeAttribute("listen", "10");
        if (this.next == null && this.wEnv != null) {
            if (this.nextName != null) {
                this.setNext(this.wEnv.getHandler(this.nextName));
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("dispatch");
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("request");
            }
        }
        super.initJkComponent();
        this.JMXRequestNote = this.wEnv.getNoteId(0, "requestNote");
        if (this.domain != null) {
            try {
                this.tpOName = new ObjectName(this.domain + ":type=ThreadPool,name=" + this.getChannelName());
                Registry.getRegistry(null, null).registerComponent((Object)this.tp, this.tpOName, null);
                this.rgOName = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getChannelName());
                Registry.getRegistry(null, null).registerComponent((Object)this.global, this.rgOName, null);
            }
            catch (Exception e) {
                LoggerUtils.getLogger().log(Level.SEVERE, "Can't register threadpool");
            }
        }
        this.tp.start();
        AprAcceptor acceptAjp = new AprAcceptor(this);
        this.tp.runIt(acceptAjp);
        LoggerUtils.getLogger().info("JK: listening on unix socket: " + this.file);
    }

    public void start() throws IOException {
    }

    public void destroy() throws IOException {
        if (this.apr == null) {
            return;
        }
        try {
            if (this.tp != null) {
                this.tp.shutdown();
            }
            super.destroyJkComponent();
            if (this.tpOName != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.tpOName);
            }
            if (this.rgOName != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.rgOName);
            }
        }
        catch (Exception e) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Error in destroy", e);
        }
    }

    public void registerRequest(Request req, MsgContext ep, int count) {
        if (this.domain != null) {
            try {
                RequestInfo rp = req.getRequestProcessor();
                rp.setGlobalProcessor(this.global);
                ObjectName roname = new ObjectName(this.getDomain() + ":type=RequestProcessor,worker=" + this.getChannelName() + ",name=JkRequest" + count);
                ep.setNote(this.JMXRequestNote, roname);
                Registry.getRegistry(null, null).registerComponent((Object)rp, roname, null);
            }
            catch (Exception ex) {
                LoggerUtils.getLogger().log(Level.WARNING, "Error registering request");
            }
        }
    }

    public int open(MsgContext ep) throws IOException {
        return super.nativeDispatch(ep.getMsg(0), ep, 4, 1);
    }

    public void close(MsgContext ep) throws IOException {
        super.nativeDispatch(ep.getMsg(0), ep, 5, 1);
    }

    public int send(Msg msg, MsgContext ep) throws IOException {
        return super.nativeDispatch(msg, ep, 7, 0);
    }

    public int receive(Msg msg, MsgContext ep) throws IOException {
        int rc = super.nativeDispatch(msg, ep, 6, 1);
        if (rc != 0) {
            LoggerUtils.getLogger().log(Level.SEVERE, "receive error:   " + rc, new Throwable());
            return -1;
        }
        msg.processHeader();
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "receive:  total read = " + msg.getLen());
        }
        return msg.getLen();
    }

    public int flush(Msg msg, MsgContext ep) throws IOException {
        return 0;
    }

    public boolean isSameAddress(MsgContext ep) {
        return false;
    }

    void acceptConnections() {
        if (this.apr == null) {
            return;
        }
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "Accepting ajp connections on " + this.file);
        }
        while (this.running) {
            try {
                MsgContext ep = this.createMsgContext();
                int status = this.open(ep);
                if (status != 0 && status != 2) {
                    LoggerUtils.getLogger().log(Level.SEVERE, "Error acceptin connection on " + this.file);
                    break;
                }
                AprConnection ajpConn = new AprConnection(this, ep);
                this.tp.runIt(ajpConn);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void processConnection(MsgContext ep) {
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "New ajp connection ");
        }
        try {
            int res;
            MsgAjp recv = new MsgAjp();
            while (this.running && (res = this.receive(recv, ep)) >= 0) {
                ep.setType(0);
                LoggerUtils.getLogger().log(Level.FINEST, "Process msg ");
                int status = this.next.invoke(recv, ep);
            }
            if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
                LoggerUtils.getLogger().log(Level.FINEST, "Closing un channel");
            }
            try {
                Request req = ep.getRequest();
                if (req != null) {
                    ObjectName roname = (ObjectName)ep.getNote(this.JMXRequestNote);
                    if (roname != null) {
                        Registry.getRegistry(null, null).unregisterComponent(roname);
                    }
                    req.getRequestProcessor().setGlobalProcessor(null);
                }
            }
            catch (Exception ee) {
                LoggerUtils.getLogger().log(Level.SEVERE, "Error, releasing connection", ee);
            }
            this.close(ep);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        int type = ep.getType();
        switch (type) {
            case 10: {
                return this.receive(msg, ep);
            }
            case 11: {
                return this.send(msg, ep);
            }
            case 12: {
                return this.flush(msg, ep);
            }
        }
        return 0;
    }

    public String getChannelName() {
        String encodedAddr = "";
        String address = this.file;
        if (address != null) {
            encodedAddr = "" + address;
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr);
        }
        return "jk-" + encodedAddr;
    }
}

