/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.jk.common;

import com.sun.grizzly.http.jk.common.AjpConstants;
import com.sun.grizzly.http.jk.common.HandlerDispatch;
import com.sun.grizzly.http.jk.common.JkInputStream;
import com.sun.grizzly.http.jk.core.JkChannel;
import com.sun.grizzly.http.jk.core.JkHandler;
import com.sun.grizzly.http.jk.core.Msg;
import com.sun.grizzly.http.jk.core.MsgContext;
import com.sun.grizzly.http.jk.util.threads.ThreadWithAttributes;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.RequestInfo;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.HexUtils;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeHeaders;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import java.util.logging.Level;

public class HandlerRequest
extends JkHandler {
    public static final int HOSTBUFFER = 10;
    private static Object lock = new Object();
    private HandlerDispatch dispatch;
    private String ajpidDir = "conf";
    private String requiredSecret = null;
    private int secretNote;
    private int tmpBufNote;
    private boolean decoded = true;
    private boolean tomcatAuthentication = true;
    private boolean registerRequests = true;
    private boolean shutdownEnabled = false;
    private boolean delayInitialRead = true;
    static int count = 0;

    public void init() {
        this.dispatch = (HandlerDispatch)this.wEnv.getHandler("dispatch");
        if (this.dispatch != null) {
            this.dispatch.registerMessageType(2, "JK_AJP13_FORWARD_REQUEST", this, null);
            this.dispatch.registerMessageType(7, "JK_AJP13_SHUTDOWN", this, null);
            this.dispatch.registerMessageType(10, "JK_AJP13_CPING_REQUEST", this, null);
            this.dispatch.registerMessageType(13, "HANDLE_THREAD_END", this, null);
            this.dispatch.registerMessageType(3, "JK_AJP13_SEND_BODY_CHUNK", this, null);
        }
        this.tmpBufNote = this.wEnv.getNoteId(0, "tmpBuf");
        this.secretNote = this.wEnv.getNoteId(0, "secret");
        if (this.next == null) {
            this.next = this.wEnv.getHandler("container");
        }
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "Container handler " + this.next + " " + this.next.getName() + " " + this.next.getClass().getName());
        }
        this.generateAjp13Id();
    }

    public void setSecret(String s) {
        this.requiredSecret = s;
    }

    public void setUseSecret(boolean b) {
        if (b) {
            this.requiredSecret = Double.toString(Math.random());
        }
    }

    public void setDecodedUri(boolean b) {
        this.decoded = b;
    }

    public boolean isTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setShutdownEnabled(boolean se) {
        this.shutdownEnabled = se;
    }

    public boolean getShutdownEnabled() {
        return this.shutdownEnabled;
    }

    public void setTomcatAuthentication(boolean newTomcatAuthentication) {
        this.tomcatAuthentication = newTomcatAuthentication;
    }

    public void setAjpidDir(String path) {
        if ("".equals(path)) {
            path = null;
        }
        this.ajpidDir = path;
    }

    public void setRegisterRequests(boolean srr) {
        this.registerRequests = srr;
    }

    public boolean getRegisterRequests() {
        return this.registerRequests;
    }

    public void setDelayInitialRead(boolean dir) {
        this.delayInitialRead = dir;
    }

    public boolean getDelayInitialRead() {
        return this.delayInitialRead;
    }

    private void generateAjp13Id() {
        block7: {
            int portInt = 8009;
            InetAddress address = null;
            if (this.requiredSecret == null || !this.shutdownEnabled) {
                return;
            }
            File f1 = new File(this.wEnv.getJkHome());
            File f2 = new File(f1, "conf");
            if (!f2.exists()) {
                LoggerUtils.getLogger().log(Level.SEVERE, "No conf dir for ajp13.id " + f2);
                return;
            }
            File sf = new File(f2, "ajp13.id");
            if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
                LoggerUtils.getLogger().log(Level.FINEST, "Using stop file: " + sf);
            }
            try {
                Properties props = new Properties();
                props.put("port", Integer.toString(portInt));
                if (address != null) {
                    props.put("address", address.getHostAddress());
                }
                if (this.requiredSecret != null) {
                    props.put("secret", this.requiredSecret);
                }
                FileOutputStream stopF = new FileOutputStream(sf);
                props.store(stopF, "Automatically generated, don't edit");
            }
            catch (IOException ex) {
                if (!LoggerUtils.getLogger().isLoggable(Level.FINEST)) break block7;
                LoggerUtils.getLogger().log(Level.FINEST, "Can't create stop file: " + sf, ex);
            }
        }
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        byte type = msg.getByte();
        ThreadWithAttributes twa = null;
        if (Thread.currentThread() instanceof ThreadWithAttributes) {
            twa = (ThreadWithAttributes)Thread.currentThread();
        }
        Object control = ep.getControl();
        MessageBytes tmpMB = (MessageBytes)ep.getNote(this.tmpBufNote);
        if (tmpMB == null) {
            tmpMB = MessageBytes.newInstance();
            ep.setNote(this.tmpBufNote, tmpMB);
        }
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "Handling " + type);
        }
        switch (type) {
            case 2: {
                String epSecret;
                try {
                    if (twa != null) {
                        twa.setCurrentStage(control, "JkDecode");
                    }
                    this.decodeRequest(msg, ep, tmpMB);
                    if (twa != null) {
                        twa.setCurrentStage(control, "JkService");
                        twa.setParam(control, ep.getRequest().unparsedURI());
                    }
                }
                catch (Exception ex) {
                    LoggerUtils.getLogger().log(Level.SEVERE, "Error decoding request ", ex);
                    msg.dump("Incomming message");
                    Response res = ep.getRequest().getResponse();
                    if (res == null) {
                        res = new Response();
                        ep.getRequest().setResponse(res);
                    }
                    res.setMessage("Bad Request");
                    res.setStatus(400);
                    return 2;
                }
                if (!(this.requiredSecret == null || (epSecret = (String)ep.getNote(this.secretNote)) != null && this.requiredSecret.equals(epSecret))) {
                    return 2;
                }
                if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
                    LoggerUtils.getLogger().log(Level.FINEST, "Calling next " + this.next.getName() + " " + this.next.getClass().getName());
                }
                int err = this.next.invoke(msg, ep);
                if (twa != null) {
                    twa.setCurrentStage(control, "JkDone");
                }
                if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
                    LoggerUtils.getLogger().log(Level.FINEST, "Invoke returned " + err);
                }
                return err;
            }
            case 7: {
                String epSecret = null;
                if (msg.getLen() > 3) {
                    msg.getBytes(tmpMB);
                    epSecret = tmpMB.toString();
                }
                if (this.requiredSecret != null && this.requiredSecret.equals(epSecret)) {
                    if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
                        LoggerUtils.getLogger().log(Level.FINEST, "Received wrong secret, no shutdown ");
                    }
                    return 2;
                }
                JkChannel ch = ep.getSource();
                if (!ch.isSameAddress(ep)) {
                    LoggerUtils.getLogger().log(Level.SEVERE, "Shutdown request not from 'same address' ");
                    return 2;
                }
                if (!this.shutdownEnabled) {
                    LoggerUtils.getLogger().log(Level.WARNING, "Ignoring shutdown request: shutdown not enabled");
                    return 2;
                }
                this.checkRequest(ep);
                this.next.invoke(msg, ep);
                LoggerUtils.getLogger().info("Exiting");
                System.exit(0);
                return 0;
            }
            case 10: {
                msg.reset();
                msg.appendByte(9);
                ep.getSource().send(msg, ep);
                ep.getSource().flush(msg, ep);
                return 0;
            }
            case 13: {
                return 0;
            }
        }
        LoggerUtils.getLogger().info("Unknown message " + type);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request checkRequest(MsgContext ep) {
        Request req = ep.getRequest();
        if (req == null) {
            req = new Request();
            Response res = new Response();
            req.setResponse(res);
            ep.setRequest(req);
            if (this.registerRequests) {
                Object object = lock;
                synchronized (object) {
                    ep.getSource().registerRequest(req, ep, count++);
                }
            }
        }
        return req;
    }

    private int decodeRequest(Msg msg, MsgContext ep, MessageBytes tmpMB) throws IOException {
        boolean isSSL;
        Request req = this.checkRequest(ep);
        RequestInfo rp = req.getRequestProcessor();
        rp.setStage(1);
        MessageBytes tmpMB2 = (MessageBytes)req.getNote(16);
        if (tmpMB2 != null) {
            tmpMB2.recycle();
        }
        req.setStartTime(System.currentTimeMillis());
        byte methodCode = msg.getByte();
        if (methodCode != -1) {
            String mName = AjpConstants.methodTransArray[methodCode - 1];
            req.method().setString(mName);
        }
        msg.getBytes(req.protocol());
        msg.getBytes(req.requestURI());
        msg.getBytes(req.remoteAddr());
        msg.getBytes(req.remoteHost());
        msg.getBytes(req.localName());
        req.setLocalPort(msg.getInt());
        boolean bl = isSSL = msg.getByte() != 0;
        if (isSSL) {
            req.scheme().setString("https");
        }
        this.decodeHeaders(ep, msg, req, tmpMB);
        this.decodeAttributes(ep, msg, req, tmpMB);
        rp.setStage(2);
        MessageBytes valueMB = req.getMimeHeaders().getValue("host");
        this.parseHost(valueMB, req);
        req.getCookies().setHeaders(req.getMimeHeaders());
        long cl = req.getContentLengthLong();
        if (cl > 0L) {
            JkInputStream jkIS = ep.getInputStream();
            jkIS.setIsReadRequired(true);
            if (!this.delayInitialRead) {
                jkIS.receive();
            }
        }
        return 0;
    }

    private int decodeAttributes(MsgContext ep, Msg msg, Request req, MessageBytes tmpMB) {
        boolean moreAttr = true;
        while (moreAttr) {
            byte attributeCode = msg.getByte();
            if (attributeCode == -1) {
                return 200;
            }
            if (attributeCode == 11) {
                req.setAttribute("javax.servlet.request.key_size", (Object)new Integer(msg.getInt()));
            }
            if (attributeCode == 10) {
                msg.getBytes(tmpMB);
                String n = tmpMB.toString();
                msg.getBytes(tmpMB);
                String v = tmpMB.toString();
                req.setAttribute(n, (Object)v);
            }
            switch (attributeCode) {
                case 1: {
                    msg.getBytes(tmpMB);
                    break;
                }
                case 2: {
                    msg.getBytes(tmpMB);
                    break;
                }
                case 3: {
                    if (this.tomcatAuthentication) {
                        msg.getBytes(tmpMB);
                        break;
                    }
                    msg.getBytes(req.getRemoteUser());
                    break;
                }
                case 4: {
                    if (this.tomcatAuthentication) {
                        msg.getBytes(tmpMB);
                        break;
                    }
                    msg.getBytes(req.getAuthType());
                    break;
                }
                case 5: {
                    msg.getBytes(req.queryString());
                    break;
                }
                case 6: {
                    msg.getBytes(req.instanceId());
                    break;
                }
                case 7: {
                    req.scheme().setString("https");
                    MessageBytes tmpMB2 = (MessageBytes)req.getNote(16);
                    if (tmpMB2 == null) {
                        tmpMB2 = MessageBytes.newInstance();
                        req.setNote(16, (Object)tmpMB2);
                    }
                    msg.getBytes(tmpMB2);
                    break;
                }
                case 8: {
                    req.scheme().setString("https");
                    msg.getBytes(tmpMB);
                    req.setAttribute("javax.servlet.request.cipher_suite", (Object)tmpMB.toString());
                    break;
                }
                case 9: {
                    req.scheme().setString("https");
                    msg.getBytes(tmpMB);
                    req.setAttribute("javax.servlet.request.ssl_session", (Object)tmpMB.toString());
                    break;
                }
                case 12: {
                    msg.getBytes(tmpMB);
                    String secret = tmpMB.toString();
                    ep.setNote(this.secretNote, secret);
                    break;
                }
                case 13: {
                    msg.getBytes(req.method());
                    break;
                }
            }
        }
        return 200;
    }

    private void decodeHeaders(MsgContext ep, Msg msg, Request req, MessageBytes tmpMB) {
        MimeHeaders headers = req.getMimeHeaders();
        int hCount = msg.getInt();
        for (int i = 0; i < hCount; ++i) {
            String hName = null;
            int isc = msg.peekInt();
            int hId = isc & 0xFF;
            MessageBytes vMB = null;
            if (40960 == (isc &= 0xFF00)) {
                msg.getInt();
                hName = AjpConstants.headerTransArray[hId - 1];
                vMB = headers.addValue(hName);
            } else {
                hId = -1;
                msg.getBytes(tmpMB);
                ByteChunk bc = tmpMB.getByteChunk();
                vMB = headers.addValue(bc.getBuffer(), bc.getStart(), bc.getLength());
            }
            msg.getBytes(vMB);
            if (hId == 8 || hId == -1 && tmpMB.equalsIgnoreCase("Content-Length")) {
                long cl = vMB.getLong();
                if (cl >= Integer.MAX_VALUE) continue;
                req.setContentLength((int)cl);
                continue;
            }
            if (hId != 7 && (hId != -1 || !tmpMB.equalsIgnoreCase("Content-Type"))) continue;
            ByteChunk bchunk = vMB.getByteChunk();
            req.contentType().setBytes(bchunk.getBytes(), bchunk.getOffset(), bchunk.getLength());
        }
    }

    private void parseHost(MessageBytes valueMB, Request request) throws IOException {
        if (valueMB == null || valueMB.isNull()) {
            request.setServerPort(request.getLocalPort());
            request.serverName().duplicate(request.localName());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        CharChunk hostNameC = (CharChunk)request.getNote(10);
        if (hostNameC == null) {
            hostNameC = new CharChunk(valueL);
            request.setNote(10, (Object)hostNameC);
        }
        hostNameC.recycle();
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b = (char)valueB[i + valueS];
            hostNameC.append(b);
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (request.scheme().equalsIgnoreCase("https")) {
                request.setServerPort(443);
            } else {
                request.setServerPort(80);
            }
            request.serverName().setChars(hostNameC.getChars(), hostNameC.getStart(), hostNameC.getLength());
        } else {
            request.serverName().setChars(hostNameC.getChars(), hostNameC.getStart(), colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS]];
                if (charValue == -1) {
                    throw new CharConversionException("Invalid char in port: " + valueB[i + valueS]);
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            request.setServerPort(port);
        }
    }
}

