/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.jk.common;

import com.sun.grizzly.http.jk.apr.AprImpl;
import com.sun.grizzly.http.jk.common.JniHandler;
import com.sun.grizzly.http.jk.core.Msg;
import com.sun.grizzly.http.jk.core.MsgContext;
import com.sun.grizzly.http.jk.core.WorkerEnv;
import com.sun.grizzly.util.IntrospectionUtils;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.C2BConverter;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;

public class Shm
extends JniHandler {
    String file = "/tmp/shm.file";
    int size;
    String host = "localhost";
    int port = 8009;
    String unixSocket;
    boolean help = false;
    boolean unregister = false;
    boolean reset = false;
    String dumpFile = null;
    Vector groups = new Vector();
    static final int SHM_WRITE_SLOT = 2;
    static final int SHM_RESET = 5;
    static final int SHM_DUMP = 6;

    public void setFile(String f) {
        this.file = f;
    }

    public void setDump(String dumpFile) {
        this.dumpFile = dumpFile;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setReset(boolean b) {
        this.reset = true;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setGroup(String grp) {
        this.groups.addElement(grp);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUnixSocket(String unixSocket) {
        this.unixSocket = unixSocket;
    }

    public void setUnregister(boolean unregister) {
        this.unregister = true;
    }

    public void init() throws IOException {
        super.initNative("shm");
        if (this.apr == null) {
            return;
        }
        if (this.file == null) {
            LoggerUtils.getLogger().log(Level.SEVERE, "No shm file, disabling shared memory");
            this.apr = null;
            return;
        }
        this.setNativeAttribute("file", this.file);
        if (this.size > 0) {
            this.setNativeAttribute("size", Integer.toString(this.size));
        }
        this.initJkComponent();
    }

    public void resetScoreboard() throws IOException {
        if (this.apr == null) {
            return;
        }
        MsgContext mCtx = this.createMsgContext();
        Msg msg = mCtx.getMsg(0);
        msg.reset();
        msg.appendByte(5);
        this.invoke(msg, mCtx);
    }

    public void dumpScoreboard(String fname) throws IOException {
        if (this.apr == null) {
            return;
        }
        MsgContext mCtx = this.createMsgContext();
        Msg msg = mCtx.getMsg(0);
        C2BConverter c2b = mCtx.getConverter();
        msg.reset();
        msg.appendByte(6);
        this.appendString(msg, fname, c2b);
        this.invoke(msg, mCtx);
    }

    public void registerTomcat(String host, int port, String unixDomain) throws IOException {
        String instanceId = host + ":" + port;
        String slotName = "TOMCAT:" + instanceId;
        MsgContext mCtx = this.createMsgContext();
        Msg msg = mCtx.getMsg(0);
        msg.reset();
        C2BConverter c2b = mCtx.getConverter();
        msg.appendByte(2);
        this.appendString(msg, slotName, c2b);
        int channelCnt = 1;
        if (unixDomain != null) {
            ++channelCnt;
        }
        msg.appendInt(this.groups.size());
        for (int i = 0; i < this.groups.size(); ++i) {
            this.appendString(msg, (String)this.groups.elementAt(i), c2b);
            this.appendString(msg, instanceId, c2b);
        }
        msg.appendInt(channelCnt);
        this.appendString(msg, "channel.socket:" + host + ":" + port, c2b);
        msg.appendInt(1);
        this.appendString(msg, "tomcatId", c2b);
        this.appendString(msg, instanceId, c2b);
        if (unixDomain != null) {
            this.appendString(msg, "channel.apr:" + unixDomain, c2b);
            msg.appendInt(1);
            this.appendString(msg, "tomcatId", c2b);
            this.appendString(msg, instanceId, c2b);
        }
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "Register " + instanceId);
        }
        this.invoke(msg, mCtx);
    }

    public void unRegisterTomcat(String host, int port) throws IOException {
        String slotName = "TOMCAT:" + host + ":" + port;
        MsgContext mCtx = this.createMsgContext();
        Msg msg = mCtx.getMsg(0);
        msg.reset();
        C2BConverter c2b = mCtx.getConverter();
        msg.appendByte(2);
        this.appendString(msg, slotName, c2b);
        msg.appendInt(0);
        msg.appendInt(0);
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "UnRegister " + slotName);
        }
        this.invoke(msg, mCtx);
    }

    public void destroy() throws IOException {
        this.destroyJkComponent();
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        if (this.apr == null) {
            return 0;
        }
        LoggerUtils.getLogger().log(Level.FINEST, "ChannelShm.invoke: " + ep);
        super.nativeDispatch(msg, ep, 22, 0);
        return 0;
    }

    public void initCli() throws IOException {
        WorkerEnv wEnv = new WorkerEnv();
        AprImpl apr = new AprImpl();
        wEnv.addHandler("apr", apr);
        wEnv.addHandler("shm", this);
        apr.init();
        if (!apr.isLoaded()) {
            LoggerUtils.getLogger().log(Level.SEVERE, "No native support. Make sure libapr.so and libjkjni.so are available in LD_LIBRARY_PATH");
            return;
        }
    }

    public void execute() {
        try {
            if (this.help) {
                return;
            }
            this.initCli();
            this.init();
            if (this.reset) {
                this.resetScoreboard();
            } else if (this.dumpFile != null) {
                this.dumpScoreboard(this.dumpFile);
            } else if (this.unregister) {
                this.unRegisterTomcat(this.host, this.port);
            } else {
                this.registerTomcat(this.host, this.port, this.unixSocket);
            }
        }
        catch (Exception ex) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Error executing Shm", ex);
        }
    }

    public void setHelp(boolean b) {
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "Usage: ");
            LoggerUtils.getLogger().log(Level.FINEST, "  Shm [OPTIONS]");
            LoggerUtils.getLogger().log(Level.FINEST, "");
            LoggerUtils.getLogger().log(Level.FINEST, "  -file SHM_FILE");
            LoggerUtils.getLogger().log(Level.FINEST, "  -group GROUP ( can be specified multiple times )");
            LoggerUtils.getLogger().log(Level.FINEST, "  -host HOST");
            LoggerUtils.getLogger().log(Level.FINEST, "  -port PORT");
            LoggerUtils.getLogger().log(Level.FINEST, "  -unixSocket UNIX_FILE");
        }
        this.help = true;
    }

    public static void main(String[] args) {
        try {
            Shm shm = new Shm();
            if (args.length == 0 || "-?".equals(args[0])) {
                shm.setHelp(true);
                return;
            }
            IntrospectionUtils.processArgs((Object)shm, (String[])args);
            shm.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

