/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.jk.server;

import com.sun.grizzly.http.jk.core.JkHandler;
import com.sun.grizzly.http.jk.core.Msg;
import com.sun.grizzly.http.jk.core.MsgContext;
import com.sun.grizzly.http.jk.server.JkMain;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.ProtocolHandler;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.RequestInfo;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyListener;
import com.sun.grizzly.util.LoggerUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.modeler.Registry;

public class JkCoyoteHandler
extends JkHandler
implements ProtocolHandler,
GrizzlyListener {
    private boolean paused = false;
    int epNote;
    Adapter adapter;
    protected JkMain jkMain = null;
    boolean started = false;

    public void setProperty(String name, String value) {
        this.getJkMain().setProperty(name, value);
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Iterator getAttributeNames() {
        return this.properties.keySet().iterator();
    }

    public void setAttribute(String name, Object value) {
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "setAttribute " + name + " " + value);
        }
        if (value instanceof String) {
            this.setProperty(name, (String)value);
        }
    }

    public Object getAttribute(String name) {
        return this.getJkMain().getProperty(name);
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public JkMain getJkMain() {
        if (this.jkMain == null) {
            this.jkMain = new JkMain();
            this.jkMain.setWorkerEnv(this.wEnv);
        }
        return this.jkMain;
    }

    public void init() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.wEnv == null) {
            this.wEnv = this.getJkMain().getWorkerEnv();
            this.wEnv.addHandler("container", this);
        }
        try {
            this.getJkMain().init();
        }
        catch (Exception ex) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Error during init", ex);
        }
    }

    public void start() {
        try {
            if (this.oname != null && this.getJkMain().getDomain() == null) {
                try {
                    ObjectName jkmainOname = new ObjectName(this.oname.getDomain() + ":type=JkMain");
                    Registry.getRegistry(null, null).registerComponent((Object)this.getJkMain(), jkmainOname, "JkMain");
                }
                catch (Exception e) {
                    LoggerUtils.getLogger().log(Level.SEVERE, "Error registering jkmain " + e);
                }
            }
            this.getJkMain().start();
        }
        catch (Exception ex) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Error during startup", ex);
        }
    }

    public void pause() throws Exception {
        if (!this.paused) {
            this.paused = true;
            this.getJkMain().pause();
        }
    }

    public void resume() throws Exception {
        if (this.paused) {
            this.paused = false;
            this.getJkMain().resume();
        }
    }

    public void destroy() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.getJkMain().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invoke(Msg msg, MsgContext ep) throws IOException {
        if (ep.isLogTimeEnabled()) {
            ep.setLong(1, System.currentTimeMillis());
        }
        Request req = ep.getRequest();
        Response res = req.getResponse();
        if (LoggerUtils.getLogger().isLoggable(Level.FINEST)) {
            LoggerUtils.getLogger().log(Level.FINEST, "Invoke " + req + " " + res + " " + req.requestURI().toString());
        }
        res.setNote(this.epNote, (Object)ep);
        ep.setStatus(1);
        RequestInfo rp = req.getRequestProcessor();
        rp.setStage(3);
        try {
            this.adapter.service(req, res);
        }
        catch (Exception ex) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Error servicing request " + req, ex);
        }
        finally {
            try {
                this.adapter.afterService(req, res);
            }
            catch (Exception ex) {
                LoggerUtils.getLogger().log(Level.SEVERE, "Error servicing request " + req, ex);
            }
        }
        if (ep.getStatus() != 2) {
            res.finish();
        }
        req.recycle();
        req.updateCounters();
        res.recycle();
        ep.recycle();
        if (ep.getStatus() == 3) {
            return 2;
        }
        ep.setStatus(0);
        rp.setStage(6);
        return 0;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName oname) throws Exception {
        this.name = "container";
        return super.preRegister(server, oname);
    }

    public String protocol() {
        return "AJP";
    }

    public void listen() throws IOException, InstantiationException {
        CountDownLatch latch = new CountDownLatch(1);
        this.init();
        this.start();
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

