/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.client;

import dojox.cometd.Client;
import dojox.cometd.Listener;
import dojox.cometd.Message;
import dojox.cometd.MessageListener;
import dojox.cometd.RemoveListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import org.mortbay.cometd.MessageImpl;
import org.mortbay.cometd.MessagePool;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpSchemes;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.log.Log;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BayeuxClient
extends MessagePool
implements Client {
    private HttpClient _client;
    private InetSocketAddress _address;
    private HttpExchange _pull;
    private HttpExchange _push;
    private String _uri = "/cometd";
    private boolean _initialized = false;
    private boolean _disconnecting = false;
    private String _clientId;
    private Listener _listener;
    private List<RemoveListener> _rListeners;
    private List<MessageListener> _mListeners;
    private List<Message> _inQ;
    private List<Message> _outQ;
    private int _batch;
    private boolean _formEncoded = true;
    private Map<String, Cookie> _cookies = new ConcurrentHashMap<String, Cookie>();
    private int _msgId;

    public BayeuxClient(HttpClient client, InetSocketAddress address, String uri) throws IOException {
        this._client = client;
        this._address = address;
        this._uri = uri;
        this._inQ = new LinkedList<Message>();
        this._outQ = new LinkedList<Message>();
        this._msgId = 0;
    }

    @Override
    public String getId() {
        return this._clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        List<Message> list = this._outQ;
        synchronized (list) {
            if (!this._initialized && this._pull == null) {
                this._pull = new Handshake();
            }
        }
    }

    public void stop() {
        try {
            this._client.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPolling() {
        List<Message> list = this._outQ;
        synchronized (list) {
            return this._pull != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliver(Client from, Message message) {
        List<Message> list = this._inQ;
        synchronized (list) {
            if (this._mListeners == null) {
                this._inQ.add(message);
            } else {
                for (MessageListener l : this._mListeners) {
                    l.deliver(from, this, message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliver(Client from, String toChannel, Object data, String id) {
        MessageImpl message = new MessageImpl();
        message.put("channel", toChannel);
        message.put("data", data);
        if (id != null) {
            message.put("id", id);
        }
        List<Message> list = this._inQ;
        synchronized (list) {
            if (this._mListeners == null) {
                this._inQ.add((Message)message);
            } else {
                for (MessageListener l : this._mListeners) {
                    l.deliver(from, this, (Message)message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Listener getListener() {
        List<Message> list = this._inQ;
        synchronized (list) {
            return this._listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMessages() {
        List<Message> list = this._inQ;
        synchronized (list) {
            return this._inQ.size() > 0;
        }
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(Message msg) {
        List<Message> list = this._outQ;
        synchronized (list) {
            this._outQ.add(msg);
            if (this._batch == 0 && this._initialized && this._push == null) {
                this._push = new Publish();
            }
        }
    }

    @Override
    public void publish(String toChannel, Object data, String msgId) {
        MessageImpl msg = new MessageImpl();
        msg.put("channel", toChannel);
        msg.put("data", data);
        if (msgId != null) {
            msg.put("id", msgId);
        }
        this.publish((Message)msg);
    }

    @Override
    public void subscribe(String toChannel) {
        MessageImpl msg = new MessageImpl();
        msg.put("channel", "/meta/subscribe");
        msg.put("subscription", toChannel);
        this.publish((Message)msg);
    }

    @Override
    public void unsubscribe(String toChannel) {
        MessageImpl msg = new MessageImpl();
        msg.put("channel", "/meta/unsubscribe");
        msg.put("subscription", toChannel);
        this.publish((Message)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean timeout) {
        MessageImpl msg = new MessageImpl();
        msg.put("channel", "/meta/disconnect");
        List<Message> list = this._outQ;
        synchronized (list) {
            this._outQ.add((Message)msg);
            this._initialized = false;
            this._disconnecting = true;
            if (this._batch == 0 && this._initialized && this._push == null) {
                this._push = new Publish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListener(Listener listener) {
        List<Message> list = this._inQ;
        synchronized (list) {
            if (this._listener != null) {
                this.removeListener(this._listener);
            }
            this._listener = listener;
            if (this._listener != null) {
                this.addListener(this._listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> takeMessages() {
        List<Message> list = this._inQ;
        synchronized (list) {
            LinkedList<Message> list2 = new LinkedList<Message>(this._inQ);
            this._inQ.clear();
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endBatch() {
        List<Message> list = this._outQ;
        synchronized (list) {
            if (--this._batch <= 0) {
                this._batch = 0;
                if ((this._initialized || this._disconnecting) && this._push == null && this._outQ.size() > 0) {
                    this._push = new Publish();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startBatch() {
        List<Message> list = this._outQ;
        synchronized (list) {
            ++this._batch;
        }
    }

    protected void customize(HttpExchange exchange) {
        StringBuilder buf = null;
        for (Cookie cookie : this._cookies.values()) {
            if (buf == null) {
                buf = new StringBuilder();
            } else {
                buf.append("; ");
            }
            buf.append(cookie.getName());
            buf.append("=");
            buf.append(cookie.getValue());
        }
        if (buf != null) {
            exchange.addRequestHeader("Cookie", buf.toString());
        }
    }

    public void setCookie(Cookie cookie) {
        this._cookies.put(cookie.getName(), cookie);
    }

    public Message[] parse(String s) throws IOException {
        boolean isJsonCommented = s != null && s.startsWith("/*") && s.endsWith("*/");
        Object batch = this.getBatchJSON().parse((JSON.Source)new JSON.StringSource(s), isJsonCommented);
        if (batch == null) {
            return new Message[0];
        }
        if (batch.getClass().isArray()) {
            return (Message[])batch;
        }
        return new Message[]{(Message)batch};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(EventListener listener) {
        List<Message> list = this._inQ;
        synchronized (list) {
            if (listener instanceof MessageListener) {
                if (this._mListeners == null) {
                    this._mListeners = new ArrayList<MessageListener>();
                }
                this._mListeners.add((MessageListener)listener);
            }
            if (listener instanceof RemoveListener) {
                if (this._rListeners == null) {
                    this._rListeners = new ArrayList<RemoveListener>();
                }
                this._rListeners.add((RemoveListener)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(EventListener listener) {
        List<Message> list = this._inQ;
        synchronized (list) {
            if (listener instanceof MessageListener && this._mListeners != null) {
                this._mListeners.remove((MessageListener)listener);
            }
            if (listener instanceof RemoveListener && this._rListeners != null) {
                this._rListeners.remove((RemoveListener)listener);
            }
        }
    }

    public int getNextMsgId() {
        int nextNumber = this._msgId++;
        return nextNumber;
    }

    private class Publish
    extends Exchange {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Publish() {
            super("publish");
            List list = BayeuxClient.this._outQ;
            synchronized (list) {
                if (BayeuxClient.this._outQ.size() == 0) {
                    return;
                }
                this.setMessages(BayeuxClient.this._outQ);
                BayeuxClient.this._outQ.clear();
            }
            try {
                BayeuxClient.this.customize((HttpExchange)this);
                BayeuxClient.this._client.send((HttpExchange)this);
            }
            catch (IOException e) {
                Log.warn((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onResponseComplete() throws IOException {
            block8: {
                super.onResponseComplete();
                try {
                    List list = BayeuxClient.this._outQ;
                    synchronized (list) {
                        BayeuxClient.this.startBatch();
                        BayeuxClient.this._push = null;
                    }
                    if (this.getResponseStatus() == 200 && this._responses != null && this._responses.length > 0) {
                        for (int i = 0; i < this._responses.length; ++i) {
                            Message msg = (Message)this._responses[i];
                            BayeuxClient.this.deliver(null, msg);
                        }
                        break block8;
                    }
                    throw new IOException("Reconnect failed: " + this.getResponseStatus());
                }
                finally {
                    BayeuxClient.this.endBatch();
                }
            }
        }
    }

    private class Connect
    extends Exchange {
        Connect() {
            super("connect");
            String connect = "{\"channel\":\"/meta/connect\",\"clientId\":\"" + BayeuxClient.this._clientId + "\"," + "\"connectionType\":\"long-polling\"}";
            this.setMessage(connect);
            try {
                BayeuxClient.this.customize((HttpExchange)this);
                BayeuxClient.this._client.send((HttpExchange)this);
            }
            catch (IOException e) {
                Log.warn((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onResponseComplete() throws IOException {
            super.onResponseComplete();
            if (this.getResponseStatus() == 200 && this._responses != null && this._responses.length > 0) {
                try {
                    BayeuxClient.this.startBatch();
                    for (int i = 0; i < this._responses.length; ++i) {
                        Message msg = (Message)this._responses[i];
                        if ("/meta/connect".equals(msg.get("channel"))) {
                            Boolean successful = (Boolean)msg.get("successful");
                            if (successful != null && successful.booleanValue()) {
                                if (!BayeuxClient.this._initialized) {
                                    BayeuxClient.this._initialized = true;
                                    List list = BayeuxClient.this._outQ;
                                    synchronized (list) {
                                        if (BayeuxClient.this._outQ.size() > 0) {
                                            BayeuxClient.this._push = (HttpExchange)new Publish();
                                        }
                                    }
                                }
                                if (!BayeuxClient.this._disconnecting) {
                                    BayeuxClient.this._pull = (HttpExchange)new Connect();
                                }
                            } else {
                                throw new IOException("Connect failed:" + this._responses[0]);
                            }
                        }
                        BayeuxClient.this.deliver(null, msg);
                    }
                }
                finally {
                    BayeuxClient.this.endBatch();
                }
            }
            throw new IOException("Connect failed: " + this.getResponseStatus());
        }
    }

    private class Handshake
    extends Exchange {
        static final String __HANDSHAKE = "[{\"version\": \"1.0\", \"minimumVersion\": \"0.9\", \"channel\": \"/meta/handshake\", \"ext\": {\"json-comment-filtered\": true}}]";

        Handshake() {
            super("handshake");
            this.setMessage(__HANDSHAKE);
            try {
                BayeuxClient.this.customize((HttpExchange)this);
                BayeuxClient.this._client.send((HttpExchange)this);
            }
            catch (IOException e) {
                Log.warn((Throwable)e);
            }
        }

        protected void onException(Throwable ex) {
            Log.warn((String)("Handshake:" + ex));
            Log.debug((Throwable)ex);
        }

        protected void onResponseComplete() throws IOException {
            Map response;
            super.onResponseComplete();
            if (this.getResponseStatus() == 200 && this._responses != null && this._responses.length > 0) {
                response = (Map)this._responses[0];
                Boolean successful = (Boolean)response.get("successful");
                if (successful == null || !successful.booleanValue()) {
                    throw new IOException("Handshake failed:" + this._responses[0]);
                }
            } else {
                throw new IOException("Handshake failed: " + this.getResponseStatus());
            }
            BayeuxClient.this._clientId = (String)response.get("clientId");
            BayeuxClient.this._pull = (HttpExchange)new Connect();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Exchange
    extends HttpExchange.ContentExchange {
        Object[] _responses;
        int _connectFailures;

        Exchange(String info) {
            this.setMethod("POST");
            this.setScheme(HttpSchemes.HTTP_BUFFER);
            this.setAddress(BayeuxClient.this._address);
            this.setURI(BayeuxClient.this._uri + "/" + info);
            this.setRequestContentType(BayeuxClient.this._formEncoded ? "application/x-www-form-urlencoded;charset=utf-8" : "text/json;charset=utf-8");
        }

        protected void setMessage(String message) {
            try {
                if (BayeuxClient.this._formEncoded) {
                    this.setRequestContent((Buffer)new ByteArrayBuffer("message=" + URLEncoder.encode(message, "utf-8")));
                } else {
                    this.setRequestContent((Buffer)new ByteArrayBuffer(message, "utf-8"));
                }
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }

        protected void setMessages(List<Message> messages) {
            try {
                for (Message msg : messages) {
                    msg.put("clientId", BayeuxClient.this._clientId);
                }
                String json = JSON.toString(messages);
                if (BayeuxClient.this._formEncoded) {
                    this.setRequestContent((Buffer)new ByteArrayBuffer("message=" + URLEncoder.encode(json, "utf-8")));
                } else {
                    this.setRequestContent((Buffer)new ByteArrayBuffer(json, "utf-8"));
                }
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }

        protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
            super.onResponseStatus(version, status, reason);
        }

        protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
            super.onResponseHeader(name, value);
            if (HttpHeaders.CACHE.getOrdinal(name) == 53) {
                String cname = null;
                String cvalue = null;
                QuotedStringTokenizer tok = new QuotedStringTokenizer(value.toString(), "=;", false, false);
                tok.setSingle(false);
                if (tok.hasMoreElements()) {
                    cname = tok.nextToken();
                }
                if (tok.hasMoreElements()) {
                    cvalue = tok.nextToken();
                }
                Cookie cookie = new Cookie(cname, cvalue);
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if ("Version".equalsIgnoreCase(token)) {
                        cookie.setVersion(Integer.parseInt(tok.nextToken()));
                        continue;
                    }
                    if ("Comment".equalsIgnoreCase(token)) {
                        cookie.setComment(tok.nextToken());
                        continue;
                    }
                    if ("Path".equalsIgnoreCase(token)) {
                        cookie.setPath(tok.nextToken());
                        continue;
                    }
                    if ("Domain".equalsIgnoreCase(token)) {
                        cookie.setDomain(tok.nextToken());
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase(token)) {
                        tok.nextToken();
                        continue;
                    }
                    if ("Max-Age".equalsIgnoreCase(token)) {
                        tok.nextToken();
                        continue;
                    }
                    if (!"Secure".equalsIgnoreCase(token)) continue;
                    cookie.setSecure(true);
                }
                BayeuxClient.this.setCookie(cookie);
            }
        }

        protected void onResponseComplete() throws IOException {
            super.onResponseComplete();
            if (this.getResponseStatus() == 200) {
                this._responses = BayeuxClient.this.parse(this.getResponseContent());
            }
        }

        protected void onExpire() {
            super.onExpire();
        }

        protected void onConnectionFailed(Throwable ex) {
            super.onConnectionFailed(ex);
            if (++this._connectFailures < 5) {
                try {
                    BayeuxClient.this._client.send((HttpExchange)this);
                }
                catch (IOException e) {
                    Log.warn((Throwable)e);
                }
            }
        }

        protected void onException(Throwable ex) {
            super.onException(ex);
        }
    }
}

