/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.client;

import dojox.cometd.Client;
import dojox.cometd.Message;
import dojox.cometd.MessageListener;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.mortbay.cometd.client.BayeuxClient;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.ajax.JSON;

public class BayeuxLoadGenerator {
    SecureRandom _random = new SecureRandom();
    HttpClient http;
    InetSocketAddress address;
    ArrayList<BayeuxClient> clients = new ArrayList();
    long _minLatency;
    long _maxLatency;
    long _totalLatency;
    AtomicInteger _got = new AtomicInteger();
    AtomicInteger _subscribed = new AtomicInteger();

    public BayeuxLoadGenerator() throws Exception {
        this.http = new HttpClient();
        this.http.setConnectorType(2);
        this.http.setMaxConnectionsPerAddress(20000);
        QueuedThreadPool pool = new QueuedThreadPool();
        pool.setMaxThreads(500);
        pool.setDaemon(true);
        this.http.setThreadPool((ThreadPool)pool);
        this.http.start();
    }

    public void generateLoad() throws Exception {
        LineNumberReader in = new LineNumberReader(new InputStreamReader(System.in));
        System.err.print("server[localhost]: ");
        String t = in.readLine().trim();
        if (t.length() == 0) {
            t = "localhost";
        }
        String host = t;
        System.err.print("port[8080]: ");
        t = in.readLine().trim();
        if (t.length() == 0) {
            t = "8080";
        }
        int port = Integer.parseInt(t);
        System.err.print("context[/cometd]: ");
        t = in.readLine().trim();
        if (t.length() == 0) {
            t = "/cometd";
        }
        String uri = t + "/cometd";
        this.initSocketAddress(host, port);
        int nclients = 100;
        int size = 50;
        int rooms = 100;
        int rooms_per_client = 1;
        int publish = 1000;
        int pause = 100;
        int burst = 10;
        int maxLatency = 5000;
        System.err.print("base[/chat/demo]: ");
        t = in.readLine().trim();
        if (t.length() == 0) {
            t = "/chat/demo";
        }
        String base = t;
        System.err.print("rooms [" + rooms + "]: ");
        t = in.readLine().trim();
        if (t.length() == 0) {
            t = "" + rooms;
        }
        rooms = Integer.parseInt(t);
        System.err.print("rooms per client [" + rooms_per_client + "]: ");
        t = in.readLine().trim();
        if (t.length() == 0) {
            t = "" + rooms_per_client;
        }
        rooms_per_client = Integer.parseInt(t);
        System.err.print("max Latency [" + maxLatency + "]: ");
        t = in.readLine().trim();
        if (t.length() == 0) {
            t = "" + maxLatency;
        }
        maxLatency = Integer.parseInt(t);
        while (true) {
            System.err.println("--");
            System.err.print("clients [" + nclients + "]: ");
            t = in.readLine().trim();
            if (t.length() == 0) {
                t = "" + nclients;
            }
            if ((nclients = Integer.parseInt(t)) < rooms || nclients % rooms != 0) {
                System.err.println("Clients must be a multiple of " + rooms);
                nclients = nclients / rooms * rooms;
                continue;
            }
            System.err.print("publish [" + publish + "]: ");
            t = in.readLine().trim();
            if (t.length() == 0) {
                t = "" + publish;
            }
            publish = Integer.parseInt(t);
            System.err.print("publish size [" + size + "]: ");
            t = in.readLine().trim();
            if (t.length() == 0) {
                t = "" + size;
            }
            size = Integer.parseInt(t);
            String chat = "";
            for (int i = 0; i < size; ++i) {
                chat = chat + "x";
            }
            System.err.print("pause [" + pause + "]: ");
            t = in.readLine().trim();
            if (t.length() == 0) {
                t = "" + pause;
            }
            pause = Integer.parseInt(t);
            System.err.print("batch [" + burst + "]: ");
            t = in.readLine().trim();
            if (t.length() == 0) {
                t = "" + burst;
            }
            burst = Integer.parseInt(t);
            this.generateLoad(uri, base, rooms, rooms_per_client, maxLatency, nclients, publish, chat, pause, burst);
        }
    }

    public void initSocketAddress(String host, int port) {
        this.address = new InetSocketAddress(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long generateLoad(String uri, String base, int rooms, int rooms_per_client, int maxLatency, int nclients, int publish, String chat, int pause, int burst) throws Exception {
        while (this.clients.size() < nclients) {
            int i;
            int u = this.clients.size();
            BayeuxClient client = new BayeuxClient(this.http, this.address, uri){

                public void deliver(Client from, Message message) {
                    if ("/meta/subscribe".equals(message.get("channel")) && ((Boolean)message.get("successful")).booleanValue()) {
                        BayeuxLoadGenerator.this._subscribed.incrementAndGet();
                    }
                    super.deliver(from, message);
                }
            };
            MessageListener listener = new MessageListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void deliver(Client fromClient, Client toClient, Message msg) {
                    String msgId;
                    Object data = msg.get("data");
                    if (data != null && (msgId = (String)msg.get("id")) != null) {
                        long latency = System.currentTimeMillis() - Long.parseLong(msgId);
                        BayeuxLoadGenerator bayeuxLoadGenerator = BayeuxLoadGenerator.this;
                        synchronized (bayeuxLoadGenerator) {
                            BayeuxLoadGenerator.this._got.getAndIncrement();
                            if (BayeuxLoadGenerator.this._maxLatency < latency) {
                                BayeuxLoadGenerator.this._maxLatency = latency;
                            }
                            if (BayeuxLoadGenerator.this._minLatency == 0L || latency < BayeuxLoadGenerator.this._minLatency) {
                                BayeuxLoadGenerator.this._minLatency = latency;
                            }
                            BayeuxLoadGenerator.this._totalLatency += latency;
                        }
                    }
                }
            };
            client.addListener(listener);
            client.start();
            this.clients.add(client);
            Thread.sleep(100L);
            if (this.clients.size() % 25 == 0) {
                i = this.clients.size();
                System.err.println("clients = " + (i >= 1000 ? "" : (i >= 100 ? "0" : (i >= 10 ? "00" : "000"))) + i);
            }
            client.startBatch();
            if (rooms_per_client == 1) {
                int room = u % rooms;
                client.subscribe(room > 0 ? base + "/" + room : base);
            } else {
                for (i = 0; i < rooms_per_client; ++i) {
                    int room = this._random.nextInt(rooms);
                    client.subscribe(room > 0 ? base + "/" + room : base);
                }
            }
            client.endBatch();
        }
        while (this.clients.size() > nclients) {
            BayeuxClient client = this.clients.remove(0);
            client.remove(false);
            this._subscribed.addAndGet(-rooms_per_client);
            if (this.clients.size() % 10 != 0) continue;
            int i = this.clients.size();
            System.err.println("clients = " + (i >= 1000 ? "" : (i >= 100 ? "0" : (i >= 10 ? "00" : "000"))) + i);
            Thread.sleep(300L);
        }
        Thread.sleep(500L);
        while (this._subscribed.get() != nclients * rooms_per_client) {
            System.err.println("Subscribed:" + this._subscribed.get() + " != " + nclients * rooms_per_client + " ...");
            Thread.sleep(1000L);
        }
        System.err.println("Clients: " + nclients + " subscribed:" + this._subscribed.get());
        BayeuxLoadGenerator client = this;
        synchronized (client) {
            this._got.set(0);
            this._minLatency = 0L;
            this._maxLatency = 0L;
            this._totalLatency = 0L;
        }
        long start = System.currentTimeMillis();
        int i = 1;
        block10: while (i <= publish) {
            int u = this._random.nextInt(nclients);
            BayeuxClient c = this.clients.get(u);
            String name = "Client" + (u >= 1000 ? "" : (u >= 100 ? "0" : (u >= 10 ? "00" : "000"))) + u;
            JSON.Literal msg = new JSON.Literal("{\"user\":\"" + name + "\",\"chat\":\"" + chat + " " + i + "\"}");
            c.startBatch();
            for (int b = 0; b < burst; ++b) {
                int room = this._random.nextInt(rooms);
                String id = "" + System.currentTimeMillis();
                c.publish(room > 0 ? base + "/" + room : base, msg, id);
                if (++i % 10 != 0) continue;
                long latency = 0L;
                BayeuxLoadGenerator bayeuxLoadGenerator = this;
                synchronized (bayeuxLoadGenerator) {
                    if (this._got.get() > 0) {
                        latency = this._totalLatency / (long)this._got.get();
                    }
                }
                if (latency > (long)maxLatency) {
                    System.err.println("\nABORTED!");
                    break block10;
                }
                char dot = (char)(48 + (int)(latency / 100L));
                System.err.print(dot);
                if (i % 1000 != 0) continue;
                System.err.println();
            }
            c.endBatch();
            if (pause <= 0) continue;
            Thread.sleep(pause);
        }
        Thread.sleep(this._maxLatency);
        for (BayeuxClient c : this.clients) {
            if (c.isPolling()) continue;
            System.err.println("PROBLEM WITH " + c);
        }
        System.err.println();
        long last = 0L;
        int sleep = 100;
        while (this._got.get() < nclients / rooms * rooms_per_client * publish) {
            System.err.println("Got:" + this._got.get() + " < " + nclients / rooms * rooms_per_client * publish + " ...");
            Thread.sleep(sleep);
            if (last != 0L && (long)this._got.get() == last) break;
            last = this._got.get();
            sleep += 100;
        }
        System.err.println("Got:" + this._got.get() + " of " + nclients / rooms * rooms_per_client * publish);
        long end = System.currentTimeMillis();
        int result = this._got.get();
        System.err.println("Got " + result + " at " + (long)(result * 1000) / (end - start) + "/s, latency min/ave/max =" + this._minLatency + "/" + this._totalLatency / (long)result + "/" + this._maxLatency + "ms");
        return result;
    }

    public static void main(String[] args) throws Exception {
        BayeuxLoadGenerator gen = new BayeuxLoadGenerator();
        gen.generateLoad();
    }
}

