/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Context;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class ContextTask
implements Callable {
    protected Context context;

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void recycle() {
        this.context = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class TaskPool<E extends ContextTask> {
        private ConcurrentLinkedQueue<E> pool = new ConcurrentLinkedQueue();

        protected TaskPool() {
        }

        public abstract E newTask();

        public E poll() {
            ContextTask task = (ContextTask)this.pool.poll();
            if (task == null) {
                task = this.newTask();
            }
            return (E)task;
        }

        public void offer(E task) {
            ((ContextTask)task).recycle();
            this.pool.offer(task);
        }
    }
}

