/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSelectionKeyHandler
implements SelectionKeyHandler {
    protected Logger logger = Controller.logger();
    protected long nextKeysExpiration = 0L;
    protected long timeout = 30000L;
    private SelectorHandler selectorHandler;

    public DefaultSelectionKeyHandler() {
    }

    public DefaultSelectionKeyHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    @Override
    public void copyTo(Copyable copy) {
        DefaultSelectionKeyHandler copyHandler = (DefaultSelectionKeyHandler)copy;
        copyHandler.selectorHandler = this.selectorHandler;
    }

    @Override
    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    @Override
    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    @Override
    public void process(SelectionKey key) {
        this.removeExpirationStamp(key);
    }

    @Override
    public void postProcess(SelectionKey key) {
        this.addExpirationStamp(key);
    }

    @Override
    public void register(Iterator<SelectionKey> iterator, int ops) {
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            SelectionKey key = iterator.next();
            iterator.remove();
            this.doRegisterKey(key, ops, currentTime);
        }
    }

    @Override
    public void register(SelectionKey key, int selectionKeyOps) {
        this.doRegisterKey(key, selectionKeyOps, System.currentTimeMillis());
    }

    protected void doRegisterKey(SelectionKey key, int selectionKeyOps, long currentTime) {
        if (!key.isValid()) {
            return;
        }
        key.interestOps(key.interestOps() | selectionKeyOps);
        Object attachment = key.attachment();
        if (attachment == null) {
            key.attach(currentTime);
        }
    }

    @Override
    public void register(SelectableChannel channel, int ops) throws ClosedChannelException {
        if (!channel.isOpen()) {
            return;
        }
        Selector selector = this.selectorHandler.getSelector();
        SelectionKey key = channel.keyFor(selector);
        long time = System.currentTimeMillis();
        if (key == null) {
            key = channel.register(selector, ops, time);
        } else {
            this.doRegisterKey(key, ops, time);
        }
    }

    @Override
    public void register(SelectionKey key, long currentTime) {
    }

    @Override
    public void expire(SelectionKey key, long currentTime) {
    }

    @Override
    public void expire(Iterator<SelectionKey> iterator) {
        if (this.timeout <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextKeysExpiration) {
            return;
        }
        this.nextKeysExpiration = currentTime + this.timeout;
        while (iterator.hasNext()) {
            Long expire;
            SelectionKey key = iterator.next();
            if (!key.isValid() || (expire = this.getExpirationStamp(key)) == null) continue;
            if (currentTime - expire >= this.timeout) {
                this.cancel(key);
                continue;
            }
            if (expire + this.timeout >= this.nextKeysExpiration) continue;
            this.nextKeysExpiration = expire + this.timeout;
        }
    }

    @Override
    public void cancel(SelectionKey key) {
        if (key == null || !key.isValid()) {
            return;
        }
        if (this.selectorHandler != null) {
            this.selectorHandler.closeChannel(key.channel());
        } else {
            this.closeChannel(key.channel());
        }
        key.attach(null);
        key.cancel();
        key = null;
    }

    @Override
    public void close(SelectionKey key) {
        this.cancel(key);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected void closeChannel(SelectableChannel channel) {
        if (channel instanceof SocketChannel) {
            Socket socket = ((SocketChannel)channel).socket();
            try {
                if (!socket.isInputShutdown()) {
                    socket.shutdownInput();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                if (!socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void removeExpirationStamp(SelectionKey key) {
        Object attachment = key.attachment();
        if (attachment != null) {
            if (attachment instanceof Long) {
                key.attach(null);
            } else if (attachment instanceof ThreadAttachment) {
                ((WorkerThread)((Object)Thread.currentThread())).attach((ThreadAttachment)attachment);
                key.attach(null);
            } else if (attachment instanceof SSLEngine) {
                SSLEngine sslEngine = (SSLEngine)attachment;
                sslEngine.getSession().removeValue("expireTime");
            }
        }
    }

    private void addExpirationStamp(SelectionKey key) {
        long currentTime = System.currentTimeMillis();
        Object attachment = key.attachment();
        if (attachment == null) {
            key.attach(currentTime);
        } else if (attachment instanceof ThreadAttachment) {
            ((ThreadAttachment)attachment).setTimeout(currentTime);
        } else if (attachment instanceof SSLEngine) {
            SSLEngine sslEngine = (SSLEngine)attachment;
            sslEngine.getSession().putValue("expireTime", currentTime);
        }
    }

    private Long getExpirationStamp(SelectionKey key) {
        block7: {
            Object attachment = key.attachment();
            if (attachment != null) {
                try {
                    if (attachment instanceof Long) {
                        return (Long)attachment;
                    }
                    if (attachment instanceof SSLEngine) {
                        SSLSession sslSession = ((SSLEngine)attachment).getSession();
                        if (sslSession != null && sslSession.getValue("expireTime") != null) {
                            return (Long)sslSession.getValue("expireTime");
                        }
                        return null;
                    }
                    if (attachment instanceof ThreadAttachment) {
                        return ((ThreadAttachment)attachment).getTimeout();
                    }
                }
                catch (ClassCastException ex) {
                    if (!this.logger.isLoggable(Level.FINEST)) break block7;
                    this.logger.log(Level.FINEST, "Invalid SelectionKey attachment", ex);
                }
            }
        }
        return null;
    }
}

