/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultPipeline;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.UDPSelectorHandler;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReadable;
import com.sun.grizzly.async.AsyncQueueWritable;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.util.ByteBufferInputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPConnectorHandler
implements ConnectorHandler<UDPSelectorHandler, CallbackHandler>,
AsyncQueueWritable,
AsyncQueueReadable {
    private UDPSelectorHandler selectorHandler;
    private CallbackHandler callbackHandler;
    private DatagramChannel datagramChannel;
    private volatile boolean isConnected;
    private Controller controller;
    private CountDownLatch isConnectedLatch;
    private boolean isStandalone = false;
    private ByteBufferInputStream inputStream;

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) throws IOException {
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        this.connect(remoteAddress, localAddress, callbackHandler, (UDPSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler, UDPSelectorHandler selectorHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler, selectorHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler, UDPSelectorHandler selectorHandler) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        if (selectorHandler == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        this.selectorHandler = selectorHandler;
        this.callbackHandler = callbackHandler;
        this.isConnectedLatch = new CountDownLatch(1);
        selectorHandler.connect(remoteAddress, localAddress, callbackHandler);
        this.inputStream = new ByteBufferInputStream();
        try {
            this.isConnectedLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void connect(SocketAddress remoteAddress) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            this.isStandalone = true;
            this.controller = new Controller();
            this.controller.setSelectorHandler(new UDPSelectorHandler(true));
            DefaultPipeline pipeline = new DefaultPipeline();
            pipeline.initPipeline();
            pipeline.startPipeline();
            this.controller.setPipeline(pipeline);
            final CountDownLatch latch = new CountDownLatch(1);
            this.controller.addStateListener(new ControllerStateListenerAdapter(){

                public void onReady() {
                    latch.countDown();
                }

                public void onException(Throwable e) {
                    latch.countDown();
                }
            });
            this.callbackHandler = new CallbackHandler<Context>(){

                @Override
                public void onConnect(IOEvent<Context> ioEvent) {
                    SelectionKey key = ioEvent.attachment().getSelectionKey();
                    try {
                        UDPConnectorHandler.this.finishConnect(key);
                    }
                    catch (IOException ex) {
                        Controller.logger().severe(ex.getMessage());
                    }
                }

                @Override
                public void onRead(IOEvent<Context> ioEvent) {
                }

                @Override
                public void onWrite(IOEvent<Context> ioEvent) {
                }
            };
            new Thread(this.controller).start();
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        this.connect(remoteAddress, localAddress, this.callbackHandler, (UDPSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    @Override
    public long read(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        SelectionKey key = this.datagramChannel.keyFor(this.selectorHandler.getSelector());
        if (blocking) {
            this.inputStream.setSelectionKey(key);
            this.inputStream.setChannelType(ByteBufferInputStream.ChannelType.DatagramChannel);
            int nRead = this.inputStream.read(byteBuffer);
            return nRead;
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking read needs a CallbackHandler");
        }
        int nRead = this.datagramChannel.read(byteBuffer);
        if (nRead == 0) {
            key.attach(this.callbackHandler);
            this.selectorHandler.register(key, 1);
        }
        return nRead;
    }

    @Override
    public long write(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        if (blocking) {
            throw new IllegalStateException("Blocking mode not supported");
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking write needs a CallbackHandler");
        }
        SelectionKey key = this.datagramChannel.keyFor(this.selectorHandler.getSelector());
        int nWrite = this.datagramChannel.write(byteBuffer);
        if (nWrite == 0) {
            key.attach(this.callbackHandler);
            this.selectorHandler.register(key, 4);
        }
        return nWrite;
    }

    @Override
    public void readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
        this.readFromAsyncQueue(buffer, callbackHandler, null);
    }

    @Override
    public void readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
        this.readFromAsyncQueue(buffer, callbackHandler, condition, null);
    }

    @Override
    public void readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        this.selectorHandler.getAsyncQueueReader().read(this.datagramChannel.keyFor(this.selectorHandler.getSelector()), buffer, callbackHandler, condition, readPostProcessor);
    }

    @Override
    public void writeToAsyncQueue(ByteBuffer buffer) throws IOException {
        this.writeToAsyncQueue(buffer, null);
    }

    @Override
    public void writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        this.writeToAsyncQueue(buffer, callbackHandler, null);
    }

    @Override
    public void writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        this.writeToAsyncQueue(buffer, callbackHandler, writePreProcessor, false);
    }

    @Override
    public void writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, boolean isCloneByteBuffer) throws IOException {
        this.selectorHandler.getAsyncQueueWriter().write(this.datagramChannel.keyFor(this.selectorHandler.getSelector()), buffer, callbackHandler, writePreProcessor, isCloneByteBuffer);
    }

    @Override
    public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer) throws IOException {
        this.writeToAsyncQueue(dstAddress, buffer, null);
    }

    @Override
    public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, null);
    }

    @Override
    public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, writePreProcessor, false);
    }

    @Override
    public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, boolean isCloneByteBuffer) throws IOException {
        this.selectorHandler.getAsyncQueueWriter().write(this.datagramChannel.keyFor(this.selectorHandler.getSelector()), dstAddress, buffer, callbackHandler, writePreProcessor, isCloneByteBuffer);
    }

    public long send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking read needs a CallbackHandler");
        }
        return this.datagramChannel.send(byteBuffer, socketAddress);
    }

    public SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        SelectionKey key = this.datagramChannel.keyFor(this.selectorHandler.getSelector());
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking read needs a CallbackHandler");
        }
        SocketAddress socketAddress = this.datagramChannel.receive(byteBuffer);
        return socketAddress;
    }

    @Override
    public void close() throws IOException {
        if (this.datagramChannel != null) {
            if (this.selectorHandler != null) {
                SelectionKey key = this.datagramChannel.keyFor(this.selectorHandler.getSelector());
                if (key == null) {
                    return;
                }
                key.cancel();
                key.attach(null);
                this.selectorHandler.closeChannel(this.datagramChannel);
            } else {
                this.datagramChannel.close();
            }
        }
        if (this.controller != null && this.isStandalone) {
            this.controller.stop();
            this.controller = null;
        }
        this.isStandalone = false;
        this.isConnected = false;
    }

    @Override
    public void finishConnect(SelectionKey key) throws IOException {
        if (Controller.logger().isLoggable(Level.FINE)) {
            Controller.logger().log(Level.FINE, "Finish connect");
        }
        this.datagramChannel = (DatagramChannel)key.channel();
        this.isConnected = this.datagramChannel.isConnected();
        this.isConnectedLatch.countDown();
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.UDP;
    }

    public boolean isConnected() {
        return this.isConnected && this.datagramChannel.isOpen();
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public SelectableChannel getUnderlyingChannel() {
        return this.datagramChannel;
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public UDPSelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }
}

