/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd.standalone;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.cometd.BayeuxCometHandler;
import com.sun.grizzly.cometd.CometdNotificationHandler;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.EventRouter;
import com.sun.grizzly.cometd.EventRouterImpl;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;

public class CometdAdapter
extends StaticResourcesAdapter
implements Adapter {
    private String contextPath = "/cometd/cometd";
    private BayeuxCometHandler bayeuxCometHandler;
    private EventRouter eventRouter;
    public static final int ADAPTER_NOTES = 1;
    private ReentrantLock initializedLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request req, final Response res) throws Exception {
        MessageBytes mb = req.requestURI();
        ByteChunk requestURI = mb.getByteChunk();
        String uri = req.requestURI().toString();
        File file = new File(this.getRootFolder(), uri);
        if (file.isDirectory()) {
            uri = uri + "index.html";
            file = new File(file, uri);
        }
        if (file.canRead()) {
            super.service(req, res);
            return;
        }
        CometEngine cometEngine = CometEngine.getEngine();
        CometContext cometContext = cometEngine.getCometContext(this.contextPath);
        this.initializedLock.lock();
        try {
            if (cometContext == null) {
                cometContext = cometEngine.register(this.contextPath);
                cometContext.setExpirationDelay(-1L);
                cometContext.setBlockingNotification(true);
                cometContext.setNotificationHandler(new CometdNotificationHandler());
                this.bayeuxCometHandler = new BayeuxCometHandler();
                this.eventRouter = new EventRouterImpl(cometContext);
                int mainHandlerHash = cometContext.addCometHandler(this.bayeuxCometHandler, true);
                cometContext.addAttribute("bayeuxCometHandler", mainHandlerHash);
            }
        }
        finally {
            this.initializedLock.unlock();
        }
        CometdRequest cometdReq = (CometdRequest)req.getNote(1);
        CometdResponse cometdRes = (CometdResponse)res.getNote(1);
        if (cometdReq == null) {
            cometdReq = new CometdRequest<Request>(req){
                private boolean requestParametersParsed;
                protected byte[] postData;
                private ByteChunk chunk;
                private byte[] body;
                {
                    this.requestParametersParsed = false;
                    this.postData = null;
                    this.chunk = new ByteChunk();
                    this.body = new byte[8192];
                }

                @Override
                public String[] getParameterValues(String s) {
                    Parameters parameters = ((Request)this.request).getParameters();
                    this.requestParametersParsed = true;
                    parameters.setEncoding("ISO-8859-1");
                    parameters.setQueryStringEncoding("ISO-8859-1");
                    parameters.handleQueryParameters();
                    int len = ((Request)this.request).getContentLength();
                    if (len > 0) {
                        try {
                            byte[] formData = this.getPostBody();
                            if (formData != null) {
                                parameters.processParameters(formData, 0, len);
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    return parameters.getParameterValues(s);
                }

                protected byte[] getPostBody() throws IOException {
                    int len = ((Request)this.request).getContentLength();
                    int actualLen = this.readPostBody(this.chunk, len);
                    if (actualLen == len) {
                        this.chunk.substract(this.body, 0, this.chunk.getLength());
                        this.chunk.recycle();
                        return this.body;
                    }
                    return null;
                }

                protected int readPostBody(ByteChunk chunk, int len) throws IOException {
                    int inputLen;
                    int offset = 0;
                    do {
                        if ((inputLen = ((Request)this.request).doRead(chunk)) > 0) continue;
                        return offset;
                    } while (len - (offset += inputLen) > 0);
                    return len;
                }
            };
            cometdRes = new CometdResponse<Response>(res){
                private StringBuffer buf;
                private ByteChunk chunk;
                {
                    super(x0);
                    this.buf = new StringBuffer();
                    this.chunk = new ByteChunk();
                }

                @Override
                public void write(String s) throws IOException {
                    this.buf.append(s);
                }

                @Override
                public void flush() throws IOException {
                    int length = this.buf.length();
                    ((Response)this.response).addHeader("Server", SelectorThread.SERVER_NAME);
                    ((Response)this.response).sendHeaders();
                    this.chunk.setBytes(this.buf.toString().getBytes(), 0, length);
                    res.doWrite(this.chunk);
                    this.chunk.recycle();
                    this.buf.delete(0, length);
                }

                @Override
                public void setContentType(String s) {
                    ((Response)this.response).setContentType(s);
                }
            };
            req.setNote(1, cometdReq);
            res.setNote(1, cometdRes);
        } else {
            cometdReq.setRequest(req);
            cometdRes.setResponse(res);
        }
        this.eventRouter.route(cometdReq, cometdRes);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }
}

