/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.container;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.container.AsyncConnectionImpl;
import com.sun.grizzly.container.GrizzletRequest;
import com.sun.grizzly.container.GrizzletResponse;
import com.sun.grizzly.grizzlet.Grizzlet;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;

public class GrizzletAdapter
extends StaticResourcesAdapter
implements Adapter {
    public static final int ADAPTER_NOTES = 1;
    public static final int POST = 6312;
    public static final int GRIZZLET = 2;
    private String cometContextName = "/comet";
    private ReentrantLock initializedLock = new ReentrantLock();
    private Grizzlet grizzlet;

    public GrizzletAdapter() {
    }

    public GrizzletAdapter(String cometContextName) {
        this.cometContextName = cometContextName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request req, Response res) throws Exception {
        MessageBytes mb = req.requestURI();
        ByteChunk requestURI = mb.getByteChunk();
        String uri = req.requestURI().toString();
        File file = new File(this.getRootFolder(), uri);
        if (file.isDirectory()) {
            uri = uri + "index.html";
            file = new File(file, uri);
        }
        if (file.canRead()) {
            super.service(req, res);
            return;
        }
        CometEngine cometEngine = CometEngine.getEngine();
        CometContext cometContext = cometEngine.getCometContext(this.cometContextName);
        this.initializedLock.lock();
        try {
            if (cometContext == null) {
                cometContext = cometEngine.register(this.cometContextName);
                cometContext.setExpirationDelay(-1L);
                cometContext.setBlockingNotification(true);
            }
        }
        finally {
            this.initializedLock.unlock();
        }
        GrizzletRequest cometReq = (GrizzletRequest)req.getNote(1);
        GrizzletResponse cometRes = (GrizzletResponse)res.getNote(1);
        AsyncConnectionImpl asyncConnection = (AsyncConnectionImpl)req.getNote(2);
        if (cometReq == null) {
            cometReq = new GrizzletRequest(req);
            cometRes = new GrizzletResponse(res);
            cometReq.setResponse(cometRes);
            asyncConnection = new AsyncConnectionImpl();
            req.setNote(1, cometReq);
            req.setNote(2, asyncConnection);
            res.setNote(1, cometRes);
        } else {
            cometReq.setRequest(req);
            cometRes.setResponse(res);
        }
        asyncConnection.setCometContext(cometContext);
        asyncConnection.setRequest(cometReq);
        asyncConnection.setResponse(cometRes);
        asyncConnection.setGrizzlet(this.grizzlet);
        this.grizzlet.onRequest(asyncConnection);
        asyncConnection.recycle();
    }

    public Grizzlet getGrizzlet() {
        return this.grizzlet;
    }

    public void setGrizzlet(Grizzlet grizzlet) {
        this.grizzlet = grizzlet;
    }

    public String getCometContextName() {
        return this.cometContextName;
    }

    public void setCometContextName(String cometContextName) {
        this.cometContextName = cometContextName;
    }
}

