/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.container;

import com.sun.grizzly.container.GrizzletResponse;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.http.Parameters;
import java.io.IOException;

public class GrizzletRequest {
    protected Request request;
    private GrizzletResponse response;
    private boolean requestParametersParsed = false;
    protected byte[] postData = null;
    private ByteChunk chunk = new ByteChunk();
    private byte[] body = new byte[8192];

    public GrizzletRequest(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    protected void setRequest(Request request) {
        this.request = request;
    }

    public String[] getParameterValues(String s) {
        Parameters parameters = this.request.getParameters();
        this.requestParametersParsed = true;
        parameters.setEncoding("ISO-8859-1");
        parameters.setQueryStringEncoding("ISO-8859-1");
        parameters.handleQueryParameters();
        int len = this.request.getContentLength();
        if (len > 0) {
            try {
                byte[] formData = this.getPostBody();
                if (formData != null) {
                    parameters.processParameters(formData, 0, len);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return parameters.getParameterValues(s);
    }

    protected byte[] getPostBody() throws IOException {
        int len = this.request.getContentLength();
        int actualLen = this.readPostBody(this.chunk, len);
        if (actualLen == len) {
            this.chunk.substract(this.body, 0, this.chunk.getLength());
            this.chunk.recycle();
            return this.body;
        }
        return null;
    }

    protected int readPostBody(ByteChunk chunk, int len) throws IOException {
        int inputLen;
        int offset = 0;
        do {
            if ((inputLen = this.request.doRead(chunk)) > 0) continue;
            return offset;
        } while (len - (offset += inputLen) > 0);
        return len;
    }

    protected GrizzletResponse getResponse() {
        return this.response;
    }

    protected void setResponse(GrizzletResponse response) {
        this.response = response;
    }
}

